/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.FlightRecording;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.MetaProducer;
import oracle.jrockit.jfr.NoSuchProducerException;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RecordingObserver;
import oracle.jrockit.jfr.RecordingOptionsImpl;
import oracle.jrockit.jfr.Repository;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.Settings;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.EventHandlerCreator;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.JavaProducerDescriptor;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JFRImpl
extends JFR
implements RecordingObserver {
    protected final Logger logger = Logger.loggerFor("jfr");
    protected final TimeZone timezone = TimeZone.getDefault();
    protected final Locale locale = Locale.getDefault();
    private final AtomicInteger idCounter = new AtomicInteger(4096);
    private final AtomicLong recordingCounter = new AtomicLong();
    private final HashMap<Integer, ProducerDescriptor> producerMap = new HashMap();
    private final HashMap<Integer, EventControl> eventsControls = new HashMap();
    private final Object eventLock = new Object();
    private final Object mbeanLock = new Object();
    private final Timer timer = new Timer("JFR request timer", true);
    private final HashMap<Long, Recording> recordings = new HashMap();
    private final Repository repository;
    private final Object startBarrier = new Object();
    private int numRealRecordings;
    private final FlightRecorder mbeanObject;
    private final Options options;
    private final MetaProducer metaProducer = new MetaProducer(this);
    private final Settings settings = new Settings(this.eventLock, this.eventsControls, this.recordings.values(), this.metaProducer);
    private Recording defaultRecording;
    List<MBeanServer> mbeanServers = Collections.emptyList();
    private boolean active = true;

    JFRImpl(Options options) {
        this.options = options;
        this.repository = new Repository(this, options, this.logger);
        try {
            this.mbeanObject = new FlightRecorder(options, this.logger, this);
        }
        catch (Exception e) {
            this.logger.error("Could not create Flight Recorder MBean", e);
            throw new InternalError();
        }
        this.loadDefaultSettings(this.settings, "default.jfs");
        List<String> settingFiles = options.settingsFiles();
        if (!settingFiles.isEmpty()) {
            for (String s : settingFiles) {
                this.loadDefaultSettings(this.settings, s);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                JFRImpl.this.shutdown();
                JFRImpl.this.destroy();
            }
        }));
        this.addProducer(this.metaProducer, this.metaProducer.getControls());
    }

    protected void startDefaultRecording() {
        if (this.options.defaultRecording()) {
            this.enableDefaultRecording();
        }
    }

    @Override
    public boolean active() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(MBeanServer server) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> l = new ArrayList<MBeanServer>(this.mbeanServers.size() + 1);
            l.addAll(this.mbeanServers);
            l.add(server);
            this.mbeanServers = l;
        }
        try {
            server.registerMBean(this.getMBean(), new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException e) {
        }
        catch (NotCompliantMBeanException e) {
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording r : this.recordings.values()) {
                if (r.objectName == null) continue;
                this.bind(r, server);
            }
        }
    }

    private void bind(Recording r, MBeanServer server) {
        try {
            FlightRecording fr = new FlightRecording(r, this.mbeanObject);
            server.registerMBean(fr, r.objectName);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (OpenDataException e) {
        }
        catch (MBeanRegistrationException e) {
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectName bind(Recording r) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (r.objectName == null) {
                    this.logger.log(MsgLevel.TRACE, "Binding recording %s", r);
                    r.objectName = new ObjectName("com.oracle.jrockit:type=FlightRecording,id=" + r.getId() + ",name=" + r.getName());
                    if (r.isReleased()) {
                        return null;
                    }
                    for (MBeanServer s : this.mbeanServers) {
                        this.bind(r, s);
                    }
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return r.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(MBeanServer server) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> l = new ArrayList<MBeanServer>(this.mbeanServers.size());
            for (MBeanServer s : this.mbeanServers) {
                if (s == server) continue;
                l.add(s);
            }
            this.mbeanServers = l;
        }
        try {
            server.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException e) {
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording r : this.recordings.values()) {
                this.unbind(r, server);
            }
        }
    }

    private void unbind(Recording r, MBeanServer server) {
        if (r.objectName == null) {
            return;
        }
        ObjectName name = r.objectName;
        try {
            server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException e) {
            // empty catch block
        }
    }

    private void unbind(Recording r) {
        assert (Thread.holdsLock(this.eventLock));
        for (MBeanServer s : this.mbeanServers) {
            this.unbind(r, s);
        }
    }

    EventSettings getEventSettings() {
        return this.settings;
    }

    @Override
    public void addProducer(Producer p, int id, List<EventHandler> events, Map<String, StringConstantPool> pools) {
        ArrayList<JavaEventDescriptor> descriptors = new ArrayList<JavaEventDescriptor>();
        for (EventHandler e : events) {
            descriptors.add(e.getDescriptor());
        }
        JavaProducerDescriptor pc = new JavaProducerDescriptor(id, p.getName(), p.getDescription(), p.getURI(), descriptors, pools);
        this.addProducer(pc, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventsToRegisteredProducer(Producer p, int id, List<EventHandler> events, Map<String, StringConstantPool> pools) {
        ProducerDescriptor pc;
        Object object = this.eventLock;
        synchronized (object) {
            pc = this.producerMap.get(id);
            if (pc == null) {
                throw new IllegalStateException("Not a registered producer " + p);
            }
            if (!pc.getURI().equals(p.getURI())) {
                throw new IllegalStateException(id + " already registered as other producer" + pc);
            }
            if (!(pc instanceof JavaProducerDescriptor)) {
                throw new InternalError();
            }
        }
        JavaProducerDescriptor jpc = (JavaProducerDescriptor)pc;
        ArrayList<JavaEventDescriptor> descriptors = new ArrayList<JavaEventDescriptor>();
        for (EventDescriptor eventDescriptor : jpc.getEvents()) {
            descriptors.add((JavaEventDescriptor)eventDescriptor);
        }
        for (EventHandler eventHandler : events) {
            descriptors.add(eventHandler.getDescriptor());
        }
        jpc = new JavaProducerDescriptor(id, p.getName(), p.getDescription(), p.getURI(), descriptors, pools);
        this.addProducer(jpc, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProducer(ProducerDescriptor pc, Collection<? extends EventControl> events) {
        this.add(pc);
        Object object = this.eventLock;
        synchronized (object) {
            this.producerMap.put(pc.getId(), pc);
            for (EventControl eventControl : events) {
                this.eventsControls.put(eventControl.getId(), eventControl);
            }
            this.settings.addEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(int pid) {
        ProducerDescriptor p = null;
        Object object = this.eventLock;
        synchronized (object) {
            p = this.producerMap.get(pid);
            if (p == null) {
                return;
            }
            ArrayList<EventControl> events = new ArrayList<EventControl>();
            EventSetting off = new EventSetting(0);
            for (EventDescriptor eventDescriptor : p.getEvents()) {
                EventControl c = this.eventsControls.remove(eventDescriptor.getId());
                c.apply(off);
                events.add(c);
            }
            this.settings.removeEvents(events);
        }
        this.rotate();
        this.remove(p);
        object = this.eventLock;
        synchronized (object) {
            this.producerMap.remove(pid);
        }
    }

    protected final void loadDefaultSettings(EventSettings dest, String path) {
        try {
            dest.addEventDefaultSet(this.findEventDefaultSet(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final EventDefaultSet findEventDefaultSet(String path) throws Exception {
        try {
            return EventDefaultSet.find(path);
        }
        catch (IOException e) {
            this.logger.log(MsgLevel.WARN, e, "Could not read %s", path);
            throw e;
        }
        catch (URISyntaxException e) {
            this.logger.log(MsgLevel.WARN, e, "Syntax error in %s", path);
            throw e;
        }
        catch (Exception e) {
            this.logger.log(MsgLevel.WARN, e, "Syntax error in %s", path);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EventDescriptor getEvent(int eventID) throws NoSuchEventException {
        Object object = this.eventLock;
        synchronized (object) {
            EventControl e = this.eventsControls.get(eventID);
            if (e == null) {
                throw new NoSuchEventException(String.valueOf(eventID));
            }
            return e.getDescriptor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProducerDescriptor getProducer(int producerID) throws NoSuchProducerException {
        Object object = this.eventLock;
        synchronized (object) {
            ProducerDescriptor d = this.producerMap.get(producerID);
            if (d == null) {
                throw new NoSuchProducerException(String.valueOf(producerID));
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<ProducerDescriptor> getProducers() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<ProducerDescriptor>(this.producerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<EventDescriptor> getEvents() {
        ArrayList<EventDescriptor> result = new ArrayList<EventDescriptor>();
        Object object = this.eventLock;
        synchronized (object) {
            for (EventControl e : this.eventsControls.values()) {
                result.add(e.getDescriptor());
            }
        }
        return result;
    }

    @Override
    public final EventHandler createHandler(JavaEventDescriptor d, Class<?> receiverType, Map<String, StringConstantPool> pools) throws InvalidEventDefinitionException {
        EventHandlerCreator c = new EventHandlerCreator(this, d, receiverType, pools);
        return c.createHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void started(Recording rec) {
        this.settings.update();
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (rec.isToDisk()) {
                int n = ++this.numRealRecordings;
                assert (n >= 1);
                if (n == 1) {
                    this.logger.debug("First recording starting...");
                    this.start(rec.isClone());
                }
                if (n > 1) {
                    this.logger.debug("Recording starting, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopping(Recording rec) {
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (rec.isToDisk()) {
                int n = --this.numRealRecordings;
                assert (n >= 0);
                if (n == 0) {
                    this.logger.debug("Last recording stopping...");
                    this.stop();
                }
                if (n > 0) {
                    this.logger.debug("Recording stopping, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopped(Recording rec) {
        boolean isCont;
        assert (!Thread.holdsLock(this.eventLock));
        assert (rec.isStoppingDone());
        Object object = this.eventLock;
        synchronized (object) {
            isCont = this.defaultRecording == rec;
        }
        this.settings.update();
        if (isCont) {
            this.disableDefaultRecording();
        }
    }

    @Override
    public final FlightRecorder getMBean() {
        return this.mbeanObject;
    }

    protected abstract void add(ProducerDescriptor var1);

    protected abstract void remove(ProducerDescriptor var1);

    protected abstract void rotate();

    protected abstract void start(boolean var1);

    protected abstract void stop();

    protected abstract void shutdown();

    public abstract ByteBuffer getThreadBuffer(int var1);

    public abstract void releaseThreadBuffer(ByteBuffer var1, boolean var2);

    public abstract long counterTime();

    public abstract long nanoToCounter(long var1);

    public abstract long stackTraceID(int var1);

    public abstract long classID(Class<?> var1);

    public abstract int threadID();

    public abstract JFRStats getJFRStats();

    @Override
    public int nextID() {
        return this.idCounter.incrementAndGet();
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    protected final void onNewChunk() {
        this.metaProducer.onNewChunk();
    }

    protected final void chunkDone() {
        this.metaProducer.chunkDone();
    }

    protected final Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChunk(RepositoryChunk chunk) {
        Object object = this.eventLock;
        synchronized (object) {
            for (Recording r : this.recordings.values()) {
                r.addChunk(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording getRecording(long id) throws NoSuchRecordingException {
        Object object = this.eventLock;
        synchronized (object) {
            Recording r = this.recordings.get(id);
            if (r == null) {
                throw new NoSuchRecordingException();
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<Recording> getRecordings() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<Recording>(this.recordings.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Recording createRecording(String name, long id, boolean isClone) throws InstanceAlreadyExistsException {
        if (name == null) {
            name = "Recording " + id;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.active) {
                throw new UnsupportedOperationException("Shutdown");
            }
            if (this.recordings.containsKey(id)) {
                throw new InstanceAlreadyExistsException(name);
            }
            Recording r = new Recording(this.logger, this.timer, name, id, this.settings.subAggregator(), isClone, this);
            this.recordings.put(id, r);
            return r;
        }
    }

    final Recording createRecording(String name) {
        try {
            return this.createRecording(name, this.recordingCounter.incrementAndGet(), false);
        }
        catch (InstanceAlreadyExistsException e) {
            throw JFRImpl.cannotHappen(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording cloneRecording(Recording r, String newName, boolean stop) throws IOException {
        Recording r2 = null;
        Object object = this.eventLock;
        synchronized (object) {
            try {
                r2 = this.createRecording(newName, this.recordingCounter.incrementAndGet(), true);
            }
            catch (InstanceAlreadyExistsException e) {
                throw JFRImpl.cannotHappen(e);
            }
        }
        r2.settingsAggregator.copy(r.settingsAggregator);
        RecordingOptionsImpl opts = new RecordingOptionsImpl(r);
        opts.setMaxAge(0L, TimeUnit.NANOSECONDS);
        opts.setMaxSize(0L);
        r2.setOptions(opts);
        if (r.isStarted()) {
            r2.start();
        }
        Object object2 = this.eventLock;
        synchronized (object2) {
            r2.copyChunks(r);
        }
        if (stop) {
            r2.stop();
        }
        r2.setMaxAge(r.getMaxAge(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        r2.setMaxSize(r.getMaxSize());
        return r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableDefaultRecording() {
        Recording r = null;
        Object object = this.eventLock;
        synchronized (object) {
            if (this.defaultRecording == null) {
                try {
                    this.defaultRecording = this.createRecording("JRockit default", 0L, false);
                }
                catch (InstanceAlreadyExistsException e) {
                    throw JFRImpl.cannotHappen(e);
                }
                this.defaultRecording.setToDisk(this.options.defaultRecordingToDisk());
                this.defaultRecording.setMaxAge(this.options.defaultRecordingMaxAge(), TimeUnit.NANOSECONDS);
                this.defaultRecording.setMaxSize(this.options.defaultRecordingMaxSize());
                r = this.defaultRecording;
            }
        }
        if (r != null) {
            r.start();
            this.bind(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableDefaultRecording() {
        Recording r = null;
        Object object = this.eventLock;
        synchronized (object) {
            r = this.defaultRecording;
            this.defaultRecording = null;
        }
        if (r != null) {
            this.release(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Recording r) {
        if (r.isRunning()) {
            try {
                r.stop();
            }
            catch (IllegalStateException e) {
            }
            catch (IOException e) {
                this.logger.log(MsgLevel.WARN, e, "Exception while stopping %s", r);
            }
        }
        r.release();
        Object object = this.eventLock;
        synchronized (object) {
            this.recordings.remove(r.getId());
            this.unbind(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContinuousModeRunning() {
        Object object = this.eventLock;
        synchronized (object) {
            return this.recordings.containsKey(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ArrayList<Recording> l;
        try {
            for (MBeanServer mBeanServer : this.mbeanServers) {
                mBeanServer.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException e) {
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        this.timer.cancel();
        Object object = this.eventLock;
        synchronized (object) {
            this.active = false;
            l = new ArrayList<Recording>(this.recordings.values());
        }
        for (Recording r : l) {
            this.release(r);
        }
        this.mbeanObject.destroy();
        this.repository.destroy();
    }
}

