/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import java.lang.management.ManagementPermission;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.management.MBeanServer;
import oracle.jrockit.jfr.DeactivatedJFR;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.NoSuchProducerException;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.PureJavaJFR;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.JavaEventDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JFR {
    static final int NATIVE_ID_HIGHEST = 4096;
    public static final long INVALID_THRESHOLD = -1L;
    public static final long INVALID_PERIOD = -1L;
    public static final int JFR_PRODUCER_ID = 0;
    public static final int JVM_PRODUCER_ID = 1;
    private static volatile JFR jfr;
    private static final Permission controlPermission;

    static void checkControl() {
        SecurityManager m = System.getSecurityManager();
        if (m != null) {
            m.checkPermission(controlPermission);
        }
    }

    static InternalError cannotHappen(Throwable t) {
        return (InternalError)new InternalError(t.getMessage()).initCause(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JFR get() {
        JFR.checkControl();
        if (jfr != null) {
            return jfr;
        }
        Class<JFR> clazz = JFR.class;
        synchronized (JFR.class) {
            if (jfr == null) {
                try {
                    jfr = VMJFR.create();
                }
                catch (NoClassDefFoundError e) {
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (jfr == null) {
                try {
                    jfr = PureJavaJFR.create();
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return jfr;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            if (jfr == null) {
                jfr = new DeactivatedJFR();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jfr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void bind(JFR ajfr) {
        Class<JFR> clazz = JFR.class;
        synchronized (JFR.class) {
            assert (jfr == null);
            jfr = ajfr;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    JFR() {
        if (jfr != null) {
            throw new InternalError("JRA init sequence out of wack.");
        }
    }

    public abstract boolean active();

    public boolean isNativeImplementation() {
        return false;
    }

    public abstract FlightRecorder getMBean();

    public abstract void bind(MBeanServer var1);

    public abstract void unbind(MBeanServer var1);

    public abstract EventHandler createHandler(JavaEventDescriptor var1, Class<?> var2, Map<String, StringConstantPool> var3) throws InvalidEventDefinitionException;

    public abstract void addProducer(Producer var1, int var2, List<EventHandler> var3, Map<String, StringConstantPool> var4);

    public abstract void removeProducer(int var1);

    public abstract void addEventsToRegisteredProducer(Producer var1, int var2, List<EventHandler> var3, Map<String, StringConstantPool> var4);

    public abstract EventDescriptor getEvent(int var1) throws NoSuchEventException;

    public abstract ProducerDescriptor getProducer(int var1) throws NoSuchProducerException;

    public abstract Collection<ProducerDescriptor> getProducers();

    public abstract Collection<EventDescriptor> getEvents();

    public abstract int getpid();

    public abstract int nextID();

    public abstract Timer getTimer();

    protected abstract boolean storeConstpool(StringConstantPool var1);

    protected abstract void addConstpool(StringConstantPool var1);

    protected abstract void removeConstpool(StringConstantPool var1);

    static {
        controlPermission = new ManagementPermission("control");
    }
}

