/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Recording;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlightRecording
extends StandardMBean
implements FlightRecordingMBean {
    private final Recording recording;
    private final FlightRecorder flightRecorder;

    public FlightRecording(Recording r, FlightRecorder f) throws OpenDataException, NotCompliantMBeanException {
        super(FlightRecordingMBean.class);
        this.flightRecorder = f;
        this.recording = r;
    }

    @Override
    public long getId() {
        return this.recording.getId();
    }

    @Override
    public CompositeData getOptions() throws OpenDataException {
        return this.flightRecorder.getRecordingOptions(this.recording);
    }

    @Override
    public void setOptions(CompositeData options) throws OpenDataException {
        this.flightRecorder.setRecordingOptions(this.recording, options);
    }

    @Override
    public void addEventDefaults(List<CompositeData> defaults) throws OpenDataException {
        this.flightRecorder.addEventDefaults(this.recording, defaults);
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.flightRecorder.getEventDefaults(this.recording);
    }

    @Override
    public void setEventDefaults(List<CompositeData> defaults) throws OpenDataException {
        this.flightRecorder.setEventDefaults(this.recording, defaults);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        return this.flightRecorder.getEventSettings(this.recording);
    }

    @Override
    public void setEventSettings(List<CompositeData> d) throws OpenDataException {
        this.flightRecorder.updateEventSettings(this.recording, d);
    }

    @Override
    public long getThreshold(int id) throws NoSuchEventException {
        return this.flightRecorder.getThreshold(this.recording, id);
    }

    @Override
    public boolean isEventEnabled(int id) throws NoSuchEventException {
        return this.flightRecorder.isEventEnabled(this.recording, id);
    }

    @Override
    public boolean isStackTraceEnabled(int id) throws NoSuchEventException {
        return this.flightRecorder.isStackTraceEnabled(this.recording, id);
    }

    @Override
    public void setEventEnabled(int id, boolean on) throws NoSuchEventException {
        this.flightRecorder.setEventEnabled(this.recording, id, on);
    }

    @Override
    public void setStackTraceEnabled(int id, boolean on) throws NoSuchEventException {
        this.flightRecorder.setStackTraceEnabled(this.recording, id, on);
    }

    @Override
    public void setThreshold(int id, long threshold) throws NoSuchEventException {
        this.flightRecorder.setThreshold(this.recording, id, threshold);
    }

    @Override
    public long getPeriod(int id) throws NoSuchEventException {
        return this.flightRecorder.getPeriod(this.recording, id);
    }

    @Override
    public void setPeriod(int id, long period) throws NoSuchEventException {
        this.flightRecorder.setPeriod(this.recording, id, period);
    }

    @Override
    public String getDestination() {
        return this.recording.getDestination();
    }

    @Override
    public long getDuration() {
        return this.recording.getDuration(TimeUnit.MILLISECONDS);
    }

    @Override
    public long getMaxAge() {
        return this.recording.getMaxAge(TimeUnit.MILLISECONDS);
    }

    @Override
    public long getMaxSize() {
        return this.recording.getMaxSize();
    }

    @Override
    public String getName() {
        return this.recording.getName();
    }

    @Override
    public long getDataSize() {
        return this.recording.getDataSize();
    }

    @Override
    public Date getStartTime() {
        return this.recording.getStartTime();
    }

    @Override
    public void setStartTime(Date d) {
        this.recording.setStartTime(d);
    }

    @Override
    public void setDestination(String path) throws IOException {
        this.recording.setDestination(path);
    }

    @Override
    public void setDuration(long time) {
        this.recording.setDuration(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isDestinationCompressed() {
        return this.recording.isDestinationCompressed();
    }

    @Override
    public void setDestinationCompressed(boolean compress) {
        JFR.checkControl();
        this.recording.setDestinationCompressed(compress);
    }

    @Override
    public void setMaxAge(long time) {
        JFR.checkControl();
        this.recording.setMaxAge(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setMaxSize(long bytes) {
        JFR.checkControl();
        this.recording.setMaxSize(bytes);
    }

    @Override
    public void start() {
        JFR.checkControl();
        this.recording.start();
    }

    @Override
    public void stop() throws IOException {
        JFR.checkControl();
        this.recording.stop();
    }

    @Override
    public void close() {
        JFR.checkControl();
        this.flightRecorder.close(this.recording);
    }

    @Override
    public boolean isRunning() {
        return this.recording.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.recording.isStarted();
    }

    @Override
    public boolean isStopped() {
        return this.recording.isStopped();
    }

    @Override
    public void closeStream(long id) throws IOException, IllegalArgumentException {
        this.flightRecorder.closeStream(id);
    }

    @Override
    public long openStream() throws IOException {
        return this.flightRecorder.openStream(this.recording);
    }

    @Override
    public long openStream(Date start, Date end) throws IOException, IllegalStateException {
        return this.flightRecorder.openStream(this.recording, start, end);
    }

    @Override
    public byte[] readStream(long id) throws IOException, IllegalArgumentException {
        return this.flightRecorder.readStream(id);
    }

    @Override
    public ObjectName cloneRecording(String newName, boolean stop) throws IOException {
        return this.flightRecorder.cloneRecording(this.recording, newName, stop);
    }

    @Override
    public void copyTo(String path, boolean compress) throws IllegalStateException, IOException {
        this.flightRecorder.copyTo(this.recording, path, compress);
    }

    @Override
    public void copyTo(String path) throws IllegalStateException, IOException {
        this.copyTo(path, false);
    }

    @Override
    public boolean isToDisk() {
        return this.recording.isToDisk();
    }

    @Override
    public void setToDisk(boolean b) {
        JFR.checkControl();
        this.recording.setToDisk(b);
    }

    @Override
    public Date getDataEndTime() {
        return this.recording.getDataEndTime();
    }

    @Override
    public Date getDataStartTime() {
        return this.recording.getDataStartTime();
    }
}

