/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jrockit.jfr.RepositoryChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChunksChannel
implements ReadableByteChannel {
    private final Iterator<RepositoryChunk> chunks;
    private RepositoryChunk current;
    private ReadableByteChannel channel;

    public ChunksChannel(List<RepositoryChunk> chunks) throws IOException {
        if (chunks.isEmpty()) {
            throw new FileNotFoundException("No chunks");
        }
        ArrayList<RepositoryChunk> l = new ArrayList<RepositoryChunk>(chunks.size());
        for (RepositoryChunk c : chunks) {
            c.use();
            l.add(c);
        }
        this.chunks = l.iterator();
        this.nextChannel();
    }

    private boolean nextChunk() {
        if (!this.chunks.hasNext()) {
            return false;
        }
        this.current = this.chunks.next();
        return true;
    }

    private boolean nextChannel() throws IOException {
        if (!this.nextChunk()) {
            return false;
        }
        this.channel = Channels.newChannel(this.current.newInputStream());
        return true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        do {
            if (this.channel == null) continue;
            assert (this.current != null);
            int r = this.channel.read(dst);
            if (r != -1) {
                return r;
            }
            this.channel.close();
            this.current.release();
            this.channel = null;
            this.current = null;
        } while (this.nextChannel());
        return -1;
    }

    public void transferTo(FileChannel out) throws IOException {
        long pos = 0L;
        do {
            long w;
            if (this.channel == null) continue;
            assert (this.current != null);
            for (long rem = this.current.getSize(); rem > 0L; rem -= w) {
                long n = Math.min(rem, 0x100000L);
                w = out.transferFrom(this.channel, pos, n);
                pos += w;
            }
            this.channel.close();
            this.current.release();
            this.channel = null;
            this.current = null;
        } while (this.nextChannel());
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        while (this.current != null) {
            this.current.release();
            if (this.nextChunk()) continue;
            return;
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

