/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.security.AccessControlContext;
import jrockit.annotations.NoInline;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public final class Threads {
    private static final int MAX_NO_PINNED = 3;

    public static native int getCurrentVMThread();

    public static native int getVMThread(Thread var0);

    public static native Thread getThread(int var0);

    public static native int getThreadIndex(int var0);

    public static native Object getCooperativeUnlockObject(int var0);

    public static native int getLockState(int var0);

    public static native void setLockState(int var0, int var1);

    public static boolean changeLockState(int n, int n2, int n3) {
        int n4 = Memory.cas(n, Reflect.offset(2305), n2, n3);
        return n4 == n2;
    }

    public static native void signalWaiter(Thread var0);

    public static native void waitForUnblockSignal();

    public static native boolean waitForNotifySignal(long var0, Object var2);

    public static native void setCurrentWaitingObject(Thread var0, Object var1);

    public static native Thread getWaitNext(Thread var0);

    public static native void setWaitNext(Thread var0, Thread var1);

    public static native Thread getLockNext(Thread var0);

    public static native void setLockNext(Thread var0, Thread var1);

    public static boolean isNotified(Thread thread) {
        return Threads.getNotifiedBy(thread) != 0L;
    }

    public static native long getNotifiedBy(Thread var0);

    public static native void setNotifiedBy(Thread var0, long var1);

    public static native long getId(Thread var0);

    public static native AccessControlContext getAccessControlContext(Thread var0);

    public static native void setAccessControlContext(Thread var0, AccessControlContext var1);

    public static native int getPrivilegedCallerClass(int var0);

    public static native void setPrivilegedCallerClass(int var0, int var1);

    public static boolean isInterrupted(Thread thread, boolean bl) {
        int n = Threads.getVMThread(thread);
        if (n != 0) {
            boolean bl2;
            boolean bl3 = bl2 = Memory.getInt(n, Reflect.offset(2307)) != 0;
            if (bl && bl2) {
                Memory.setInt(n, Reflect.offset(2307), 0);
            }
            return bl2;
        }
        return false;
    }

    public static native void setBlockingOnObject(Thread var0, Object var1);

    public static native Object getBlockingOnObject(Thread var0);

    public static native void setBlockingOnThreadIdx(Thread var0, int var1);

    public static native int getBlockingOnThreadIdx(Thread var0);

    public static native void setThreadStatus(Thread var0, int var1);

    public static native int getThreadStatus(Thread var0);

    public static native void shortNap(int var0);

    public static native void yield();

    public static native void sleep(int var0);

    public static native long getLockTime();

    public static native double getDiffTime(long var0);

    public static native void ioSignalWakeup(long var0);

    public static Object pinObject(Object object) {
        return Threads.pinObject(Threads.getCurrentVMThread(), object);
    }

    @NoSafePoint
    @NoInline
    public static Object pinObject(int n, Object object) {
        int n2 = Memory.getInt(n, Reflect.offset(2310));
        if (n2 < 3) {
            Memory.setObject(n, Reflect.offset(2311) + n2 * 4, object);
            Memory.setInt(n, Reflect.offset(2310), n2 + 1);
            return object;
        }
        throw new InternalError("pinned object overflow!");
    }

    public static void unpinLastObject() {
        Threads.unpinLastObject(Threads.getCurrentVMThread());
    }

    @NoSafePoint
    public static void unpinLastObject(int n) {
        int n2 = Memory.getInt(n, Reflect.offset(2310));
        if (n2 <= 0) {
            throw new InternalError("pinned object underflow!");
        }
        Memory.setAddress(n, Reflect.offset(2311) + --n2 * 4, 0);
        Memory.setInt(n, Reflect.offset(2310), n2);
    }

    public static native Object getBlockThreadStop(Thread var0);

    public static native void setBlockThreadStop(Thread var0, Object var1);

    public static native long getMonitorBlockedCount(int var0);

    public static native void setMonitorBlockedCount(int var0, long var1);

    public static native long getMonitorBlockedTime(int var0);

    public static native void setMonitorBlockedTime(int var0, long var1);

    public static native long getMonitorWaitedCount(int var0);

    public static native void setMonitorWaitedCount(int var0, long var1);

    public static native long getMonitorWaitedTime(int var0);

    public static native void setMonitorWaitedTime(int var0, long var1);

    public static void incrementMonitorBlockedCount(int n) {
        Threads.setMonitorBlockedCount(n, Threads.getMonitorBlockedCount(n) + 1L);
    }

    public static void incrementMonitorBlockedTime(int n, long l) {
        Threads.setMonitorBlockedTime(n, Threads.getMonitorBlockedTime(n) + l);
    }

    public static void incrementMonitorWaitedCount(int n) {
        Threads.setMonitorWaitedCount(n, Threads.getMonitorWaitedCount(n) + 1L);
    }

    public static void incrementMonitorWaitedTime(int n, long l) {
        Threads.setMonitorWaitedTime(n, Threads.getMonitorWaitedTime(n) + l);
    }
}

