/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.lang.ref.SoftReference;
import jrockit.vm.Access;
import jrockit.vm.Intrinsics;
import jrockit.vm.Memory;

public class Strings {
    private static final Access.Lang langAccess = Access.lang();
    private static final int INTERN_HIT_RESIZE = 10000000;
    private static final int INTERN_MISS_RESIZE = 100000;
    private static transient int hit;
    private static transient int conflictmiss;
    private static transient int currentsize;
    private static transient int[] primes;
    private static transient SoftReference internCacheRef;
    private static transient Object internLock;

    private Strings() {
    }

    public static int getUTF8Length(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                ++n;
                continue;
            }
            if (c <= '\u07ff') {
                n += 2;
                continue;
            }
            n += 3;
        }
        return n;
    }

    private static void utf2unicode(int n, int n2, char[] cArray, int n3) {
        int n4 = 0;
        n4 = 0;
        while (n4 < n2) {
            byte by = Memory.getByte(n, n4++);
            boolean bl = true;
            int n5 = 128;
            switch (by >> 4 & 0xF) {
                default: {
                    n5 = (char)by;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    break;
                }
                case 12: 
                case 13: {
                    byte by2 = Memory.getByte(n, n4);
                    if ((by2 & 0xC0) != 128) break;
                    char c = (char)(by & 0x1F);
                    char c2 = (char)(by2 & 0x3F);
                    n5 = (char)((c << 6) + c2);
                    ++n4;
                    break;
                }
                case 14: {
                    char c2;
                    char c;
                    byte by2 = Memory.getByte(n, n4);
                    byte by3 = Memory.getByte(n, n4 + 1);
                    if ((by2 & 0xC0) != 128) break;
                    if ((by3 & 0xC0) == 128) {
                        c = (char)(by & 0xF);
                        c2 = (char)(by2 & 0x3F);
                        char c3 = (char)(by3 & 0x3F);
                        n5 = (char)(((c << 6) + c2 << 6) + c3);
                        n4 += 2;
                        break;
                    }
                    ++n4;
                }
            }
            cArray[n3++] = n5;
        }
    }

    private static String[] resizeCache(int n, String[] stringArray) {
        try {
            String[] stringArray2 = new String[primes[n]];
            SoftReference<String[]> softReference = new SoftReference<String[]>(stringArray2);
            Intrinsics.membar(0);
            internCacheRef = softReference;
            stringArray = stringArray2;
            currentsize = n;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String intern(String string) {
        int n;
        int n2;
        String string2;
        Object object;
        SoftReference softReference = internCacheRef;
        Intrinsics.membar(1);
        String[] stringArray = (String[])softReference.get();
        if (stringArray == null) {
            object = internLock;
            synchronized (object) {
                stringArray = (String[])internCacheRef.get();
                if (stringArray == null) {
                    stringArray = Strings.resizeCache(0, null);
                }
                hit = 0;
                conflictmiss = 0;
            }
        }
        if (hit > 10000000 || conflictmiss > 100000) {
            object = internLock;
            synchronized (object) {
                if ((hit > 10000000 || conflictmiss > 100000) && currentsize < primes.length - 1 && conflictmiss * 98 > hit) {
                    stringArray = Strings.resizeCache(currentsize + 1, stringArray);
                }
                hit = 0;
                conflictmiss = 0;
            }
        }
        if ((string2 = stringArray[n2 = ((n = string.hashCode()) & Integer.MAX_VALUE) % stringArray.length]) != null) {
            if (string.equals(string2)) {
                ++hit;
                return string2;
            }
            ++conflictmiss;
        }
        stringArray[n2] = string2 = Strings.intern0(string, string.length(), n);
        return string2;
    }

    private static native String intern0(String var0, int var1, int var2);

    public static int indexOf(String string, int n, int n2, int n3, int n4, int n5, String string2, char c) {
        char[] cArray = Access.getStringValue(string);
        int n6 = Access.getStringOffset(string);
        int n7 = string.length() + n6;
        int n8 = n6 + n;
        char[] cArray2 = Access.getStringValue(string2);
        int n9 = string2.length();
        while (n8 <= n7 - n9) {
            int n10 = n9 - 1;
            char c2 = c;
            char c3 = cArray[n10 + n8];
            while (c2 == c3) {
                if (--n10 < 0) {
                    return n8 - n6;
                }
                c2 = cArray2[n10];
                c3 = cArray[n10 + n8];
            }
            if (c3 < n4 || c3 > n5) {
                if (n10 == n9 - 1) {
                    n8 += n9;
                    continue;
                }
                n8 += Math.max(Memory.getInt(n2, n10 * 4), 1 + n10);
                continue;
            }
            int n11 = n9 - 1;
            n8 += Math.max(Memory.getInt(n2, n10 * 4), Memory.getInt(n3, (c3 - n4) * 4) - n11 + n10);
        }
        return -1;
    }

    public static int compare(String string, String string2) {
        char[] cArray = Access.getStringValue(string);
        char[] cArray2 = Access.getStringValue(string2);
        int n = string.length();
        int n2 = string2.length();
        int n3 = Access.getStringOffset(string);
        int n4 = Access.getStringOffset(string2);
        int n5 = Math.min(n, n2);
        if (n3 == n4) {
            if (n3 == 0) {
                int n6;
                int n7;
                int n8;
                int n9 = n5 * 2 + (Memory.arrayHeaderSize() - 2);
                for (n8 = Memory.arrayHeaderSize(); n8 < n9; n8 += 4) {
                    n7 = Memory.getInt(cArray, n8);
                    if (n7 == (n6 = Memory.getInt(cArray2, n8))) continue;
                    char c = (char)n7;
                    char c2 = (char)n6;
                    if (c != c2) {
                        return c - c2;
                    }
                    return (char)(n7 >> 16) - (char)(n6 >> 16);
                }
                if (n8 == n9 && (n7 = (int)Memory.getChar(cArray, n8)) != (n6 = (int)Memory.getChar(cArray2, n8))) {
                    return n7 - n6;
                }
            } else {
                int n10 = n5 + n3;
                for (int i = n3; i < n10; ++i) {
                    char c = cArray[i];
                    char c3 = cArray2[i];
                    if (c == c3) continue;
                    return c - c3;
                }
            }
        } else {
            while (n5-- != 0) {
                char c;
                char c4;
                if ((c4 = cArray[n3++]) == (c = cArray2[n4++])) continue;
                return c4 - c;
            }
        }
        return n - n2;
    }

    public static int indexOf(String string, String string2, int n) {
        char[] cArray = Access.getStringValue(string);
        char[] cArray2 = Access.getStringValue(string2);
        int n2 = Access.getStringOffset(string);
        int n3 = Access.getStringOffset(string2);
        int n4 = string.length();
        int n5 = string2.length();
        if (n >= n4) {
            return n5 == 0 ? n4 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        return Intrinsics.sse4indexOf(string, string2, cArray, n + n2, cArray2, n3, n4 - n, string2.length(), n);
    }

    static {
        currentsize = 0;
        primes = new int[]{337, 2417, 7919, 29147, 54269};
        internCacheRef = new SoftReference<String[]>(new String[primes[currentsize]]);
        internLock = new Object();
    }
}

