/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.ForceInline;

public final class StringMaker {
    public static final int MAX_APPEND_SEQUENCE_LENGTH = 16;
    public static final int MAX_APPEND_SUBSEQUENCE_LENGTH = 3;
    private String[] strings;
    private int size;

    @ForceInline
    public StringMaker() {
        this.strings = new String[16];
    }

    public StringMaker(int n) {
        this.strings = new String[n];
    }

    public StringMaker(String string) {
        this();
        if (string == null) {
            string.length();
        }
        this.add0(string);
    }

    public StringMaker(String string, int n) {
        this(n);
        if (string == null) {
            string.length();
        }
        this.add0(string);
    }

    @ForceInline
    public StringMaker append(int n) {
        return this.append0(Integer.toString(n));
    }

    @ForceInline
    public StringMaker append(boolean bl) {
        return this.append0(Boolean.toString(bl));
    }

    @ForceInline
    public StringMaker append(char c) {
        return this.append0(Character.toString(c));
    }

    @ForceInline
    public StringMaker append(long l) {
        return this.append0(Long.toString(l));
    }

    @ForceInline
    public StringMaker append(float f) {
        return this.append0(Float.toString(f));
    }

    @ForceInline
    public StringMaker append(double d) {
        return this.append0(Double.toString(d));
    }

    public StringMaker append(Object object) {
        return this.append(String.valueOf(object));
    }

    @ForceInline
    private void add0(String string) {
        this.strings[this.size++] = string;
    }

    @ForceInline
    private void add(String string) {
        this.strings[this.size++] = string == null ? "null" : string;
    }

    @ForceInline
    private StringMaker append0(String string) {
        this.add0(string);
        return this;
    }

    @ForceInline
    public StringMaker append(String string) {
        this.add(string);
        return this;
    }

    public StringMaker append(String string, String string2) {
        this.add(string);
        this.add(string2);
        return this;
    }

    public StringMaker append(String string, String string2, String string3) {
        this.add(string);
        this.add(string2);
        this.add(string3);
        return this;
    }

    public StringMaker append(String string, int n) {
        this.add(string);
        this.add0(Integer.toString(n));
        return this;
    }

    public StringMaker append(int n, String string) {
        this.add0(Integer.toString(n));
        this.add(string);
        return this;
    }

    public StringMaker append(String string, String string2, int n) {
        this.add(string);
        this.add(string2);
        this.add0(Integer.toString(n));
        return this;
    }

    public StringMaker append(String string, long l, String string2) {
        this.add(string);
        this.add0(Long.toString(l));
        this.add(string2);
        return this;
    }

    public StringMaker append(String string, Object object, String string2) {
        this.add(string);
        this.add(String.valueOf(object));
        this.add(string2);
        return this;
    }

    private int stringHashCode(int n, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            n = 31 * n + cArray[i];
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            n = this.stringHashCode(n, this.strings[i].toCharArray());
        }
        return n;
    }

    public String toString() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            n += this.strings[i].length();
        }
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            this.strings[i].getChars(0, this.strings[i].length(), cArray, n2);
            n2 += this.strings[i].length();
        }
        return new String(cArray);
    }
}

