/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.HashMap;
import jrockit.vm.Access;
import sun.security.action.GetPropertyAction;

class StringCoding {
    private static StringEncoder defaultEncoder;
    private static StringDecoder defaultDecoder;
    private static HashMap quickAliases;

    private StringCoding() {
    }

    private static byte[] trim(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] trim(char[] cArray, int n) {
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        return defaultDecoder.decode(byArray, n, n2);
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        return defaultEncoder.encode(cArray, n, n2);
    }

    private static void makeDefaultCoders(String string) {
        Object object;
        if (string == null) {
            object = new GetPropertyAction("file.encoding");
            string = AccessController.doPrivileged(object);
        }
        object = null;
        StringDecoder stringDecoder = null;
        stringDecoder = StringCoding.getDecoder(string);
        object = StringCoding.getEncoder(string);
        if (object == null || stringDecoder == null) {
            throw new InternalError(string + " not available");
        }
        defaultEncoder = object;
        defaultDecoder = stringDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAlias(String string) {
        if (quickAliases != null) return (String)quickAliases.get(string);
        Class<StringCoding> clazz = StringCoding.class;
        synchronized (StringCoding.class) {
            if (quickAliases != null) return (String)quickAliases.get(string);
            quickAliases = new HashMap();
            quickAliases.put("MS1252", "Cp1252");
            quickAliases.put("windows-1252", "Cp1252");
            quickAliases.put("iso-ir-100", "8859_1");
            quickAliases.put("ISO_8859-1", "8859_1");
            quickAliases.put("latin1", "8859_1");
            quickAliases.put("l1", "8859_1");
            quickAliases.put("IBM819", "8859_1");
            quickAliases.put("cp819", "8859_1");
            quickAliases.put("csISOLatin1", "8859_1");
            quickAliases.put("819", "8859_1");
            quickAliases.put("IBM-819", "8859_1");
            quickAliases.put("ISO8859_1", "8859_1");
            quickAliases.put("ISO_8859-1:1987", "8859_1");
            quickAliases.put("ISO_8859_1", "8859_1");
            quickAliases.put("8859_1", "8859_1");
            quickAliases.put("ISO8859-1", "8859_1");
            quickAliases.put("ISO-8859-1", "8859_1");
            quickAliases.put("iso-ir-6", "US_ASCII");
            quickAliases.put("ANSI_X3.4-1986", "US_ASCII");
            quickAliases.put("ISO_646.irv:1991", "US_ASCII");
            quickAliases.put("ASCII", "US_ASCII");
            quickAliases.put("ISO646-US", "US_ASCII");
            quickAliases.put("us", "US_ASCII");
            quickAliases.put("IBM367", "US_ASCII");
            quickAliases.put("cp367", "US_ASCII");
            quickAliases.put("csASCII", "US_ASCII");
            quickAliases.put("US-ASCII", "US_ASCII");
            quickAliases.put("646", "US_ASCII");
            quickAliases.put("iso_646.irv:1983", "US_ASCII");
            quickAliases.put("ANSI_X3.4-1968", "US_ASCII");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)quickAliases.get(string);
        }
    }

    private static StringEncoder getEncoder(String string) {
        if (string.equals("Cp1252")) {
            return new MS1252SE();
        }
        if (string.equals("8859_1")) {
            return new ISO8859_1SE();
        }
        if (string.equals("US_ASCII")) {
            return new USASCIISE();
        }
        String string2 = StringCoding.getAlias(string);
        if (string2 != null) {
            return StringCoding.getEncoder(string2);
        }
        return new DefaultEncoder(string);
    }

    private static StringDecoder getDecoder(String string) {
        if (string.equals("Cp1252")) {
            return new MS1252SD();
        }
        if (string.equals("8859_1")) {
            return new ISO8859_1SD();
        }
        if (string.equals("US_ASCII")) {
            return new USASCIISD();
        }
        String string2 = StringCoding.getAlias(string);
        if (string2 != null) {
            return StringCoding.getDecoder(string2);
        }
        return new DefaultDecoder(string);
    }

    static {
        StringCoding.makeDefaultCoders(null);
    }

    private static class USASCIISD
    extends StringDecoder {
        private USASCIISD() {
        }

        @Override
        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n + n2;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                byte by = byArray[i];
                cArray[n4] = by >= 0 ? (int)by : 65533;
                ++n4;
            }
            return cArray;
        }
    }

    private static class USASCIISE
    extends StringEncoder {
        private USASCIISE() {
        }

        @Override
        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0080') {
                    byArray[n4] = (byte)c;
                } else if (c < '\ufffe') {
                    byArray[n4] = 63;
                } else {
                    byArray[n4] = 63;
                    return StringCoding.trim(byArray, n4 + 1);
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }
    }

    static class ISO8859_1SD
    extends StringDecoder {
        ISO8859_1SD() {
        }

        @Override
        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n + n2;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                cArray[n4] = (char)(byArray[i] & 0xFF);
                ++n4;
            }
            return cArray;
        }
    }

    static class ISO8859_1SE
    extends StringEncoder {
        ISO8859_1SE() {
        }

        @Override
        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0100') {
                    byArray[n4] = (byte)c;
                } else if (c < '\ufffe') {
                    byArray[n4] = 63;
                } else {
                    byArray[n4] = 63;
                    return StringCoding.trim(byArray, n4 + 1);
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }
    }

    private static class MS1252SD
    extends StringDecoder {
        private static final char[] cp1252c1chars = "\u20ac\ufffd\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\ufffd\u017d\ufffd\ufffd\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\ufffd\u017e\u0178".toCharArray();

        private MS1252SD() {
        }

        @Override
        char[] decode(byte[] byArray, int n, int n2) {
            char[] cArray = new char[n2];
            int n3 = n2 + n;
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                char c = (char)(byArray[i] & 0xFF);
                cArray[n4] = c >= '\u0080' && c <= '\u009f' ? cp1252c1chars[c - 128] : c;
                ++n4;
            }
            return cArray;
        }
    }

    static class MS1252SE
    extends StringEncoder {
        MS1252SE() {
        }

        @Override
        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if (c < '\u0080' || c > '\u009f' && c < '\u0100') {
                    byArray[n4] = (byte)c;
                } else {
                    switch (c) {
                        case '\u20ac': {
                            byArray[n4] = -128;
                            break;
                        }
                        case '\u201a': {
                            byArray[n4] = -126;
                            break;
                        }
                        case '\u0192': {
                            byArray[n4] = -125;
                            break;
                        }
                        case '\u201e': {
                            byArray[n4] = -124;
                            break;
                        }
                        case '\u2026': {
                            byArray[n4] = -123;
                            break;
                        }
                        case '\u2020': {
                            byArray[n4] = -122;
                            break;
                        }
                        case '\u2021': {
                            byArray[n4] = -121;
                            break;
                        }
                        case '\u02c6': {
                            byArray[n4] = -120;
                            break;
                        }
                        case '\u2030': {
                            byArray[n4] = -119;
                            break;
                        }
                        case '\u0160': {
                            byArray[n4] = -118;
                            break;
                        }
                        case '\u2039': {
                            byArray[n4] = -117;
                            break;
                        }
                        case '\u0152': {
                            byArray[n4] = -116;
                            break;
                        }
                        case '\u017d': {
                            byArray[n4] = -114;
                            break;
                        }
                        case '\u2018': {
                            byArray[n4] = -111;
                            break;
                        }
                        case '\u2019': {
                            byArray[n4] = -110;
                            break;
                        }
                        case '\u201c': {
                            byArray[n4] = -109;
                            break;
                        }
                        case '\u201d': {
                            byArray[n4] = -108;
                            break;
                        }
                        case '\u2022': {
                            byArray[n4] = -107;
                            break;
                        }
                        case '\u2013': {
                            byArray[n4] = -106;
                            break;
                        }
                        case '\u2014': {
                            byArray[n4] = -105;
                            break;
                        }
                        case '\u02dc': {
                            byArray[n4] = -104;
                            break;
                        }
                        case '\u2122': {
                            byArray[n4] = -103;
                            break;
                        }
                        case '\u0161': {
                            byArray[n4] = -102;
                            break;
                        }
                        case '\u203a': {
                            byArray[n4] = -101;
                            break;
                        }
                        case '\u0153': {
                            byArray[n4] = -100;
                            break;
                        }
                        case '\u017e': {
                            byArray[n4] = -98;
                            break;
                        }
                        case '\u0178': {
                            byArray[n4] = -97;
                            break;
                        }
                        case '\ufffe': 
                        case '\uffff': {
                            byArray[n4] = 63;
                            return StringCoding.trim(byArray, n4 + 1);
                        }
                        default: {
                            byArray[n4] = 63;
                        }
                    }
                }
                ++n5;
                ++n4;
            }
            return byArray;
        }
    }

    static class DefaultDecoder
    extends StringDecoder {
        private String csn;

        public DefaultDecoder(String string) {
            this.csn = string;
        }

        @Override
        char[] decode(byte[] byArray, int n, int n2) {
            try {
                return Access.lang().stringCodingDefaultDecode(this.csn, byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                StringCoding.makeDefaultCoders("ISO-8859-1");
                return Access.lang().stringCodingDefaultDecode(byArray, n, n2);
            }
        }
    }

    static class DefaultEncoder
    extends StringEncoder {
        private String csn;

        public DefaultEncoder(String string) {
            this.csn = string;
        }

        @Override
        byte[] encode(char[] cArray, int n, int n2) {
            try {
                return Access.lang().stringCodingDefaultEncode(this.csn, cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                StringCoding.makeDefaultCoders("ISO-8859-1");
                return Access.lang().stringCodingDefaultEncode(cArray, n, n2);
            }
        }
    }

    private static abstract class StringDecoder {
        private StringDecoder() {
        }

        abstract char[] decode(byte[] var1, int var2, int var3);
    }

    private static abstract class StringEncoder {
        private StringEncoder() {
        }

        abstract byte[] encode(char[] var1, int var2, int var3);
    }
}

