/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrockit.annotations.ImmutableLoad;
import jrockit.annotations.Internal;
import jrockit.annotations.NoSafePoint;
import jrockit.annotations.ThrowCycle;
import jrockit.vm.Access;
import jrockit.vm.Allocator;
import jrockit.vm.Memory;
import jrockit.vm.Threads;

public class Reflect {
    private Reflect() {
    }

    public static native int offset(int var0);

    public static Object checkArrayStore(Object object, Object object2) {
        int n;
        int n2;
        if (object2 != null && (n2 = IClassBlock.getCB(object2)) != (n = IClassBlock.getInnerCB(IClassBlock.getCB(object)))) {
            boolean bl;
            int n3 = IClassBlock.getJlcType(n);
            switch (n3) {
                case 1: {
                    bl = IClassBlock.isAssignableNormal(n, n2);
                    break;
                }
                case 3: {
                    bl = IClassBlock.isAssignableArray(n, n2);
                    break;
                }
                case 2: {
                    bl = IClassBlock.isAssignableInterface(n, n2);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) {
                throw new ArrayStoreException("Cannot store " + object2.getClass().getName() + " in " + object.getClass().getName());
            }
        }
        return object;
    }

    public static native long getFieldOffset(Field var0);

    public static native void markFieldInitialized(int var0);

    @ThrowCycle
    private static native void fillInStackTrace0(Throwable var0);

    @ThrowCycle
    private static Throwable fillInStackTrace(Throwable throwable) {
        if (Access.throwableGetNoBacktrace(throwable) != Threads.getCurrentVMThread()) {
            Reflect.fillInStackTrace0(throwable);
            Access.throwableSetNoBacktrace(throwable, 0);
        }
        return throwable;
    }

    private static Object clone(Object object) throws CloneNotSupportedException {
        if (!(object instanceof Cloneable)) {
            throw new CloneNotSupportedException(object.getClass().getName());
        }
        if (IClassBlock.isArray(object)) {
            int n = Memory.getArrayLength(object);
            Object object2 = Allocator.allocArray(object.getClass(), n);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }
        return Reflect.clone0(object);
    }

    private static native Object clone0(Object var0);

    private static native String getConstantString(Class var0, int var1);

    @Internal
    private static void checkParameterTypes(Class[] classArray, Object[] objectArray) {
        if (classArray.length > 0) {
            if (objectArray == null || objectArray.length != classArray.length) {
                throw new IllegalArgumentException("wrong number of arguments");
            }
            for (int i = 0; i < classArray.length; ++i) {
                if (IClass.isInvocationAssignable(classArray[i], objectArray[i])) continue;
                throw new IllegalArgumentException("argument type mismatch");
            }
        } else if (objectArray != null && objectArray.length != 0) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
    }

    private static Object invoke0(Method method, Object object, Object[] objectArray) {
        if (!Modifier.isStatic(method.getModifiers())) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!method.getDeclaringClass().isInstance(object)) {
                throw new IllegalArgumentException("" + object);
            }
        }
        Reflect.checkParameterTypes(method.getParameterTypes(), objectArray);
        return Reflect.invokeMethod(method, object, objectArray);
    }

    private static Object newInstance0(Constructor constructor, Object[] objectArray) {
        Reflect.checkParameterTypes(constructor.getParameterTypes(), objectArray);
        Object object = Allocator.allocObject(constructor.getDeclaringClass());
        Reflect.invokeMethod(constructor, object, objectArray);
        return object;
    }

    @Internal
    private static native Object invokeMethod(Object var0, Object var1, Object[] var2);

    public static final class IZipEntry {
        public static long getCSize(int n) {
            long l = Memory.getInt(n, Reflect.offset(3840));
            if (l == 0L) {
                l = IZipEntry.getSize(n);
            }
            return l;
        }

        public static int getMethod(int n) {
            if (Memory.getInt(n, Reflect.offset(3840)) == 0) {
                return 0;
            }
            return 8;
        }

        public static long getSize(int n) {
            return Memory.getInt(n, Reflect.offset(3841));
        }

        public static long getPos(int n) {
            return Memory.getLong(n, Reflect.offset(3842));
        }
    }

    public static final class IZStream {
        public static final int Z_OK = 0;
        public static final int Z_STREAM_END = 1;
        public static final int Z_NEED_DICT = 2;
        public static final int Z_ERRNO = -1;
        public static final int Z_STREAM_ERROR = -2;
        public static final int Z_DATA_ERROR = -3;
        public static final int Z_MEM_ERROR = -4;
        public static final int Z_BUF_ERROR = -5;
        public static final int Z_VERSION_ERROR = -6;

        public static int getAvailIn(int n) {
            return Memory.getInt(n, Reflect.offset(3328));
        }

        public static int getAvailOut(int n) {
            return Memory.getInt(n, Reflect.offset(3329));
        }
    }

    public static class IClass {
        @ImmutableLoad
        public static Class get(int n) {
            return n == 0 ? null : IClass.getNoCheck(n);
        }

        @ImmutableLoad
        public static Class get(Object object) {
            return IClassBlock.getClass(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static Class getNoCheck(int n) {
            return (Class)Memory.getObject(n, Reflect.offset(518));
        }

        @ImmutableLoad
        public static int getID(Object object) {
            return Memory.getAddress(IClassBlock.getCB(object), Reflect.offset(256));
        }

        @ImmutableLoad
        public static int getID(Class clazz) {
            return Memory.getAddress(clazz, Reflect.offset(4097));
        }

        @ImmutableLoad
        public static int getIName(Class clazz) {
            return IClass.getIName(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getIName(int n) {
            return Memory.getAddress(n, Reflect.offset(516));
        }

        @ImmutableLoad
        public static int getInstanceSize(Class clazz) {
            return IClass.getInstanceSize(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getInstanceSize(int n) {
            return Memory.getInt(n, Reflect.offset(523));
        }

        @ImmutableLoad
        public static ClassLoader getClassLoader(Class clazz) {
            return IClass.getClassLoader(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static ClassLoader getClassLoader(int n) {
            return (ClassLoader)Memory.getObject(n, Reflect.offset(513));
        }

        @ImmutableLoad
        public static Class getSuperclass(Class clazz) {
            if (clazz.isInterface()) {
                return null;
            }
            int n = IClass.getID(clazz);
            int n2 = Memory.getAddress(n, Reflect.offset(512));
            return IClass.get(n2);
        }

        @ImmutableLoad
        public static Class getInnerType(Class clazz) {
            return IClassBlock.getClass(IClassBlock.getInnerCB(IClassBlock.getCB(clazz)));
        }

        @ImmutableLoad
        public static int getInnerType(int n) {
            return IClassBlock.getClassID(IClassBlock.getInnerCB(IClassBlock.getCB(n)));
        }

        @ImmutableLoad
        public static Class getComponentType(Class clazz) {
            if (!IClass.isArray(clazz)) {
                return null;
            }
            return IClass.getInnerType(clazz);
        }

        @ImmutableLoad
        public static int getStatVars(int n) {
            return Memory.getAddress(n, Reflect.offset(556));
        }

        @ImmutableLoad
        public static int getStatVars(Class clazz) {
            return IClass.getStatVars(IClass.getID(clazz));
        }

        @ImmutableLoad
        static int getFlags(int n) {
            return Memory.getShort(n, Reflect.offset(521));
        }

        @ImmutableLoad
        public static int getJlcType(int n) {
            return Memory.getInt(n, Reflect.offset(522));
        }

        @ImmutableLoad
        public static int getInnerJlcType(int n) {
            return IClassBlock.getInnerJlcType(IClassBlock.getCB(n));
        }

        @ImmutableLoad
        public static int getAccessFlags(int n) {
            return Memory.getInt(n, Reflect.offset(519)) & 0xFFFF;
        }

        @ImmutableLoad
        public static int getAccessFlags(Class clazz) {
            return IClass.getAccessFlags(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean hasClinit(int n) {
            return (IClass.getFlags(n) & 1) == 1;
        }

        @ImmutableLoad
        public static boolean hasClinit(Class clazz) {
            return IClass.hasClinit(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean hasFinalizer(int n) {
            return (IClass.getFlags(n) & 2) == 2;
        }

        @ImmutableLoad
        public static boolean hasFinalizer(Class clazz) {
            return IClass.hasFinalizer(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean isAnnotation(Class clazz) {
            return (IClass.getAccessFlags(IClass.getID(clazz)) & 0x2000) != 0;
        }

        @ImmutableLoad
        public static boolean isEnum(Class clazz) {
            return (IClass.getAccessFlags(IClass.getID(clazz)) & 0x4000) != 0;
        }

        @ImmutableLoad
        public static boolean isNormal(int n) {
            return IClass.getJlcType(n) == 1;
        }

        @ImmutableLoad
        public static boolean isNormal(Class clazz) {
            return IClass.isNormal(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean isArray(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) == 3;
        }

        @ImmutableLoad
        public static boolean isInterface(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) == 2;
        }

        @ImmutableLoad
        public static boolean isPrimitive(Class clazz) {
            return IClass.getJlcType(IClass.getID(clazz)) < 0;
        }

        @ImmutableLoad
        public static void ensureInitialized(Class clazz) {
            if (!IClass.isInitialized(clazz)) {
                IClass.runClinit(clazz);
            }
        }

        @ImmutableLoad
        public static boolean isInitialized(Class clazz) {
            int n = IClass.getID(clazz);
            byte by = Memory.getByte(n, Reflect.offset(520));
            return by == 2;
        }

        private static native void runClinit(Class var0);

        public static boolean isAssignable(Class clazz, Class clazz2) {
            return IClassBlock.isAssignable(IClassBlock.getCB(clazz), IClassBlock.getCB(clazz2));
        }

        public static boolean isAssignableNormal(Class clazz, Class clazz2) {
            return IClassBlock.isAssignableNormal(IClassBlock.getCB(clazz), IClassBlock.getCB(clazz2));
        }

        public static boolean isAssignable(Object object, Object object2) {
            return IClassBlock.isAssignable(IClassBlock.getCB(object), IClassBlock.getCB(object2));
        }

        public static boolean isAssignable(Class clazz, Object object) {
            return IClassBlock.isAssignable(IClassBlock.getCB(clazz), IClassBlock.getCB(object));
        }

        public static boolean isAssignable(int n, Object object) {
            return IClassBlock.isAssignable(IClassBlock.getCB(n), IClassBlock.getCB(object));
        }

        public static boolean isInstance(Class clazz, Object object) {
            return object != null && IClass.isAssignable(clazz, object);
        }

        public static boolean isInvocationAssignable(Class clazz, Object object) {
            if (clazz.isPrimitive()) {
                if (object == null) {
                    return false;
                }
                int n = IClassBlock.getCB(object);
                if (IClassBlock.getJlcType(n) == 3) {
                    return false;
                }
                int n2 = IClassBlock.getJlcType(IClassBlock.getCB(clazz));
                int n3 = IClassBlock.getInnerCB(n);
                if (n3 == 0) {
                    return false;
                }
                int n4 = IClassBlock.getJlcType(n3);
                if (n2 == n4) {
                    return true;
                }
                switch (n2) {
                    case -6: {
                        return n4 == -4;
                    }
                    case -8: {
                        return n4 == -4 || n4 == -6 || n4 == -5;
                    }
                    case -10: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -5;
                    }
                    case -7: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -10 || n4 == -5;
                    }
                    case -9: {
                        return n4 == -4 || n4 == -6 || n4 == -8 || n4 == -7 || n4 == -10 || n4 == -5;
                    }
                }
                return false;
            }
            return object == null ? true : IClass.isAssignable(clazz, object);
        }

        @ImmutableLoad
        public static int getPackage(int n) {
            return Memory.getAddress(n, Reflect.offset(560));
        }

        @ImmutableLoad
        public static int getPackage(Class clazz) {
            return IClass.getPackage(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static boolean isSamePackage(int n, int n2) {
            return IClass.getPackage(n) == IClass.getPackage(n2);
        }

        @ImmutableLoad
        public static boolean isSamePackage(Class clazz, Class clazz2) {
            return IClass.getPackage(IClass.getID(clazz)) == IClass.getPackage(IClass.getID(clazz2));
        }
    }

    public static class IClassBlock {
        @ImmutableLoad
        public static native int getCB(Object var0);

        @ImmutableLoad
        public static int getCB(Class clazz) {
            return IClassBlock.getCB(IClass.getID(clazz));
        }

        @ImmutableLoad
        public static int getCB(int n) {
            return Memory.getAddress(n, Reflect.offset(517));
        }

        @ImmutableLoad
        public static int getClassID(int n) {
            return Memory.getAddress(n, Reflect.offset(256));
        }

        @ImmutableLoad
        public static Class getClass(int n) {
            return IClass.get(IClassBlock.getClassID(n));
        }

        @ImmutableLoad
        public static int getJlcType(int n) {
            return Memory.getInt(n, Reflect.offset(266));
        }

        @ImmutableLoad
        public static int getJlcType(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static int getInnerCB(int n) {
            return Memory.getAddress(n, Reflect.offset(257));
        }

        @ImmutableLoad
        public static int getInnerCB(Object object) {
            return IClassBlock.getInnerCB(IClassBlock.getCB(object));
        }

        @ImmutableLoad
        public static int getInnerCB(Class clazz) {
            return IClassBlock.getInnerCB(IClassBlock.getCB(clazz));
        }

        @ImmutableLoad
        public static int getInnerJlcType(int n) {
            return IClassBlock.getJlcType(IClassBlock.getInnerCB(n));
        }

        @ImmutableLoad
        public static int getInnerJlcType(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getInnerCB(object));
        }

        @ImmutableLoad
        public static boolean isArray(int n) {
            return IClassBlock.getJlcType(n) == 3;
        }

        @ImmutableLoad
        public static boolean isArray(Object object) {
            return IClassBlock.getJlcType(IClassBlock.getCB(object)) == 3;
        }

        @ImmutableLoad
        public static int getTGClassHeight(int n) {
            return Memory.getInt(n, Reflect.offset(264));
        }

        public static boolean isAssignableNormal(int n, int n2) {
            int n3;
            if (n == n2) {
                return true;
            }
            int n4 = IClassBlock.getJlcType(n2);
            if (n4 < 1) {
                return false;
            }
            int n5 = IClassBlock.getTGClassHeight(n);
            int n6 = IClassBlock.getTGClassHeight(n2);
            if (n5 == 0) {
                return true;
            }
            if (n5 > n6) {
                return false;
            }
            if (n5 < 8) {
                n3 = Memory.getAddress(n2, Reflect.offset(261) + n5 * 4);
            } else {
                int n7 = Memory.getAddress(n2, Reflect.offset(262));
                n3 = Memory.getAddress(n7, (n5 - 8) * 4);
            }
            return n3 == n;
        }

        public static boolean isAssignableArray(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n);
            int n4 = IClassBlock.getJlcType(n2);
            while (n3 == 3 && n4 == 3) {
                n = IClassBlock.getInnerCB(n);
                n2 = IClassBlock.getInnerCB(n2);
                n3 = IClassBlock.getJlcType(n);
                n4 = IClassBlock.getJlcType(n2);
            }
            if (n3 == 3 || n4 == 3) {
                return n3 == 1 && IClassBlock.getTGClassHeight(n) == 0;
            }
            if (n3 < 1) {
                return n3 == n4;
            }
            if (n3 == 2) {
                return IClassBlock.isAssignableInterface(n, n2);
            }
            return IClassBlock.isAssignableNormal(n, n2);
        }

        public static boolean isAssignable(int n, Object object) {
            return IClassBlock.isAssignable(n, IClassBlock.getCB(object));
        }

        @NoSafePoint
        public static boolean isAssignableInterface(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n2);
            if (n3 < 1) {
                return false;
            }
            int n4 = Memory.getInt(n, Reflect.offset(265));
            int n5 = Memory.getAddress(n2, Reflect.offset(259));
            int n6 = Memory.getAddress(n5, n4 * 4);
            return n == n6;
        }

        public static boolean isAssignable(int n, int n2) {
            if (n == n2) {
                return true;
            }
            int n3 = IClassBlock.getJlcType(n);
            int n4 = IClassBlock.getJlcType(n2);
            switch (n3) {
                case 1: {
                    return n4 >= 1 ? IClassBlock.isAssignableNormal(n, n2) : false;
                }
                case 3: {
                    return n4 >= 1 ? IClassBlock.isAssignableArray(n, n2) : false;
                }
                case 2: {
                    return n4 >= 1 ? IClassBlock.isAssignableInterface(n, n2) : false;
                }
            }
            return n3 == n4;
        }

        static void incrLockCounter(int n, int n2) {
            int n3 = Memory.getAddress(n, Reflect.offset(271));
            Memory.setInt(n3, n2, Memory.getInt(n3, n2) + 1);
        }
    }
}

