/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.ForceInline;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Memory;

public class Memset {
    @ForceInline
    @NoSafePoint
    private static void set_checkbounds(int n, int n2, int n3) {
        if (n2 < 0 || n2 + n3 > n) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @ForceInline
    @NoSafePoint
    public static void set(byte by, byte[] byArray, int n, int n2) {
        Memset.set_checkbounds(byArray.length, n, n2);
        int n3 = n + n2;
        int n4 = n3 - n >> 3;
        Memset.memset(Memset.make_pattern(by), byArray, Memory.arrayHeaderSize() + n, n4);
        n += n4 * 8;
        while (n < n3) {
            byArray[n++] = by;
        }
    }

    @ForceInline
    @NoSafePoint
    public static void set(char c, char[] cArray, int n, int n2) {
        Memset.set_checkbounds(cArray.length, n, n2);
        int n3 = n + n2;
        int n4 = (n3 - n) * 2 >> 3;
        Memset.memset(Memset.make_pattern(c), cArray, Memory.arrayHeaderSize() + n * 2, n4);
        n += n4 * 4;
        while (n < n3) {
            cArray[n++] = c;
        }
    }

    @ForceInline
    @NoSafePoint
    public static void set(int n, int[] nArray, int n2, int n3) {
        Memset.set_checkbounds(nArray.length, n2, n3);
        int n4 = n2 + n3;
        int n5 = (n4 - n2) * 4 >> 3;
        Memset.memset(Memset.make_pattern(n), nArray, Memory.arrayHeaderSize() + n2 * 4, n5);
        n2 += n5 * 2;
        while (n2 < n4) {
            nArray[n2++] = n;
        }
    }

    private static native void memset(int var0, Object var1, int var2, int var3);

    @ForceInline
    private static int make_pattern(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2 << 24 | n2 << 16 | n2 << 8 | n2;
    }

    @ForceInline
    private static int make_pattern(char c) {
        char c2 = c;
        return c2 << 16 | c2 & 0xFFFF;
    }

    @ForceInline
    private static int make_pattern(int n) {
        return n;
    }
}

