/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.ForceInline;
import jrockit.vm.GC;
import jrockit.vm.Intrinsics;
import jrockit.vm.Locks;
import jrockit.vm.VM;

public final class Memory {
    private static volatile long maxDirectMemory = -1L;
    private static volatile long reservedDirectMemory = 0L;
    public static final int BYTES_INT = 4;
    public static final int BYTES_FLOAT = 4;
    public static final int BYTES_DOUBLE = 8;
    public static final int BYTES_LONG = 8;
    public static final int BYTES_SHORT = 2;
    public static final int BYTES_CHAR = 2;
    public static final int BYTES_BYTE = 1;
    public static final int BYTES_BOOLEAN = 1;
    public static final int BYTES_ADDRESS = 4;
    private static int BYTES_OBJECTREF;

    private Memory() {
    }

    public static native Object getObject(Object var0, int var1);

    public static native int getAddress(Object var0, int var1);

    public static native long getLong(Object var0, int var1);

    public static native int getInt(Object var0, int var1);

    public static native short getShort(Object var0, int var1);

    public static native char getChar(Object var0, int var1);

    public static native byte getByte(Object var0, int var1);

    public static native int getUnsignedByte(Object var0, int var1);

    public static native boolean getBoolean(Object var0, int var1);

    public static native double getDouble(Object var0, int var1);

    public static native float getFloat(Object var0, int var1);

    public static native Object getObject(int var0, int var1);

    public static native int getAddress(int var0, int var1);

    public static native long getLong(int var0, int var1);

    public static native int getInt(int var0, int var1);

    public static native short getShort(int var0, int var1);

    public static native char getChar(int var0, int var1);

    public static native byte getByte(int var0, int var1);

    public static native int getUByte(int var0, int var1);

    public static native boolean getBoolean(int var0, int var1);

    public static native double getDouble(int var0, int var1);

    public static native float getFloat(int var0, int var1);

    public static Object getObject(int n) {
        return Memory.getObject(n, 0);
    }

    public static int getAddress(int n) {
        return Memory.getAddress(n, 0);
    }

    public static long getLong(int n) {
        return Memory.getLong(n, 0);
    }

    public static int getInt(int n) {
        return Memory.getInt(n, 0);
    }

    public static short getShort(int n) {
        return Memory.getShort(n, 0);
    }

    public static char getChar(int n) {
        return Memory.getChar(n, 0);
    }

    public static byte getByte(int n) {
        return Memory.getByte(n, 0);
    }

    public static boolean getBoolean(int n) {
        return Memory.getBoolean(n, 0);
    }

    public static double getDouble(int n) {
        return Memory.getDouble(n, 0);
    }

    public static float getFloat(int n) {
        return Memory.getFloat(n, 0);
    }

    public static native void setObject(Object var0, int var1, Object var2);

    public static native void setObject(Class var0, int var1, Object var2);

    public static native void setAddress(Object var0, int var1, int var2);

    public static native void setLong(Object var0, int var1, long var2);

    public static native void setInt(Object var0, int var1, int var2);

    public static native void setShort(Object var0, int var1, short var2);

    public static native void setChar(Object var0, int var1, char var2);

    public static native void setByte(Object var0, int var1, byte var2);

    public static native void setBoolean(Object var0, int var1, boolean var2);

    public static native void setDouble(Object var0, int var1, double var2);

    public static native void setFloat(Object var0, int var1, float var2);

    public static native void setObject(int var0, int var1, Object var2);

    public static native void setAddress(int var0, int var1, int var2);

    public static native void setAddress(int var0, int var1, Object var2);

    public static native void setLong(int var0, int var1, long var2);

    public static native void setInt(int var0, int var1, int var2);

    public static native void setShort(int var0, int var1, short var2);

    public static native void setChar(int var0, int var1, char var2);

    public static native void setByte(int var0, int var1, byte var2);

    public static native void setBoolean(int var0, int var1, boolean var2);

    public static native void setDouble(int var0, int var1, double var2);

    public static native void setFloat(int var0, int var1, float var2);

    public static void setObject(int n, Object object) {
        Memory.setObject(n, 0, object);
    }

    public static void setAddress(int n, int n2) {
        Memory.setAddress(n, 0, n2);
    }

    public static void setLong(int n, long l) {
        Memory.setLong(n, 0, l);
    }

    public static void setInt(int n, int n2) {
        Memory.setInt(n, 0, n2);
    }

    public static void setShort(int n, short s) {
        Memory.setShort(n, 0, s);
    }

    public static void setChar(int n, char c) {
        Memory.setChar(n, 0, c);
    }

    public static void setByte(int n, byte by) {
        Memory.setByte(n, 0, by);
    }

    public static void setBoolean(int n, boolean bl) {
        Memory.setBoolean(n, 0, bl);
    }

    public static void setDouble(int n, double d) {
        Memory.setDouble(n, 0, d);
    }

    public static void setFloat(int n, float f) {
        Memory.setFloat(n, 0, f);
    }

    public static void setBooleanVolatile(Object object, int n, boolean bl) {
        Memory.setBoolean(object, n, bl);
        Intrinsics.membar(0);
    }

    public static void setBooleanVolatile(Class clazz, int n, boolean bl) {
        Memory.setBoolean(clazz, n, bl);
        Intrinsics.membar(0);
    }

    public static void setBooleanVolatile(int n, boolean bl) {
        Memory.setBoolean(0, n, bl);
        Intrinsics.membar(0);
    }

    public static boolean getBooleanVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getBoolean(object, n);
    }

    public static boolean getBooleanVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getBoolean(0, n);
    }

    public static void setByteVolatile(Object object, int n, byte by) {
        Memory.setByte(object, n, by);
        Intrinsics.membar(0);
    }

    public static void setByteVolatile(Class clazz, int n, byte by) {
        Memory.setByte(clazz, n, by);
        Intrinsics.membar(0);
    }

    public static void setByteVolatile(int n, byte by) {
        Memory.setByte(0, n, by);
        Intrinsics.membar(0);
    }

    public static byte getByteVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getByte(object, n);
    }

    public static byte getByteVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getByte(0, n);
    }

    public static void setCharVolatile(Object object, int n, char c) {
        Memory.setChar(object, n, c);
        Intrinsics.membar(0);
    }

    public static void setCharVolatile(Class clazz, int n, char c) {
        Memory.setChar(clazz, n, c);
        Intrinsics.membar(0);
    }

    public static void setCharVolatile(int n, char c) {
        Memory.setChar(0, n, c);
        Intrinsics.membar(0);
    }

    public static char getCharVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getChar(object, n);
    }

    public static char getCharVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getChar(0, n);
    }

    public static void setShortVolatile(Object object, int n, short s) {
        Memory.setShort(object, n, s);
        Intrinsics.membar(0);
    }

    public static void setShortVolatile(Class clazz, int n, short s) {
        Memory.setShort(clazz, n, s);
        Intrinsics.membar(0);
    }

    public static void setShortVolatile(int n, short s) {
        Memory.setShort(0, n, s);
        Intrinsics.membar(0);
    }

    public static short getShortVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getShort(object, n);
    }

    public static short getShortVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getShort(0, n);
    }

    public static void setIntVolatile(Object object, int n, int n2) {
        Memory.setInt(object, n, n2);
        Intrinsics.membar(0);
    }

    public static void setIntVolatile(Class clazz, int n, int n2) {
        Memory.setInt(clazz, n, n2);
        Intrinsics.membar(0);
    }

    public static void setIntVolatile(int n, int n2) {
        Memory.setInt(0, n, n2);
        Intrinsics.membar(0);
    }

    public static int getIntVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getInt(object, n);
    }

    public static int getIntVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getInt(0, n);
    }

    public static void setFloatVolatile(Object object, int n, float f) {
        Memory.setFloat(object, n, f);
        Intrinsics.membar(0);
    }

    public static void setFloatVolatile(Class clazz, int n, float f) {
        Memory.setFloat(clazz, n, f);
        Intrinsics.membar(0);
    }

    public static void setFloatVolatile(int n, float f) {
        Memory.setFloat(0, n, f);
        Intrinsics.membar(0);
    }

    public static float getFloatVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getFloat(object, n);
    }

    public static float getFloatVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getFloat(0, n);
    }

    public static void setDoubleVolatile(Object object, int n, double d) {
        Memory.setDouble(object, n, d);
        Intrinsics.membar(0);
    }

    public static void setDoubleVolatile(Class clazz, int n, double d) {
        Memory.setDouble(clazz, n, d);
        Intrinsics.membar(0);
    }

    public static void setDoubleVolatile(int n, double d) {
        Memory.setDouble(0, n, d);
        Intrinsics.membar(0);
    }

    public static double getDoubleVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getDouble(object, n);
    }

    public static double getDoubleVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getDouble(0, n);
    }

    public static void setObjectVolatile(Object object, int n, Object object2) {
        Memory.setObject(object, n, object2);
        Intrinsics.membar(0);
    }

    public static void setObjectVolatile(Class clazz, int n, Object object) {
        Memory.setObject(clazz, n, object);
        Intrinsics.membar(0);
    }

    public static void setObjectVolatile(int n, Object object) {
        Memory.setObject(0, n, object);
        Intrinsics.membar(0);
    }

    public static Object getObjectVolatile(Object object, int n) {
        Intrinsics.membar(1);
        return Memory.getObject(object, n);
    }

    public static Object getObjectVolatile(int n) {
        Intrinsics.membar(1);
        return Memory.getObject(0, n);
    }

    public static native void setLongVolatile(Object var0, int var1, long var2);

    public static void setLongVolatile(int n, long l) {
        Memory.setLongVolatile(null, n, l);
    }

    public static native long getLongVolatile(Object var0, int var1);

    public static long getLongVolatile(int n) {
        return Memory.getLongVolatile(null, n);
    }

    public static native long cas(Object var0, int var1, long var2, long var4);

    public static native int cas(Object var0, int var1, int var2, int var3);

    public static native short cas(Object var0, int var1, short var2, short var3);

    public static native byte cas(Object var0, int var1, byte var2, byte var3);

    public static native Object cas(Object var0, int var1, Object var2, Object var3);

    public static native long cas(int var0, int var1, long var2, long var4);

    public static native int cas(int var0, int var1, int var2, int var3);

    public static native short cas(int var0, int var1, short var2, short var3);

    public static native byte cas(int var0, int var1, byte var2, byte var3);

    public static native Object cas(int var0, int var1, Object var2, Object var3);

    public static long swap(Object object, int n, long l) {
        long l2;
        while (Memory.cas(object, n, l2 = Memory.getLong(object, n), l) != l2) {
        }
        return l2;
    }

    public static int swap(Object object, int n, int n2) {
        int n3;
        while (Memory.cas(object, n, n3 = Memory.getInt(object, n), n2) != n3) {
        }
        return n3;
    }

    public static int getArrayData(long[] lArray, int n) {
        return Memory.objectAsAddress(lArray) + Memory.arrayHeaderSize() + 8 * n;
    }

    public static int getArrayData(int[] nArray, int n) {
        return Memory.objectAsAddress(nArray) + Memory.arrayHeaderSize() + 4 * n;
    }

    public static int getArrayData(short[] sArray, int n) {
        return Memory.objectAsAddress(sArray) + Memory.arrayHeaderSize() + 2 * n;
    }

    public static int getArrayData(char[] cArray, int n) {
        return Memory.objectAsAddress(cArray) + Memory.arrayHeaderSize() + 2 * n;
    }

    public static int getArrayData(byte[] byArray, int n) {
        return Memory.objectAsAddress(byArray) + Memory.arrayHeaderSize() + 1 * n;
    }

    public static int getArrayData(boolean[] blArray, int n) {
        return Memory.objectAsAddress(blArray) + Memory.arrayHeaderSize() + 1 * n;
    }

    public static int getArrayData(double[] dArray, int n) {
        return Memory.objectAsAddress(dArray) + Memory.arrayHeaderSize() + 8 * n;
    }

    public static int getArrayData(float[] fArray, int n) {
        return Memory.objectAsAddress(fArray) + Memory.arrayHeaderSize() + 4 * n;
    }

    public static native int bswap(int var0);

    public static native short bswap(short var0);

    public static native char bswap(char var0);

    public static native long bswap(long var0);

    public static float bswap(float f) {
        return Float.intBitsToFloat(Memory.bswap(Float.floatToRawIntBits(f)));
    }

    public static double bswap(double d) {
        return Double.longBitsToDouble(Memory.bswap(Double.doubleToRawLongBits(d)));
    }

    public static int ntoh(int n) {
        return Memory.bswap(n);
    }

    public static short ntoh(short s) {
        return Memory.bswap(s);
    }

    public static char ntoh(char c) {
        return Memory.bswap(c);
    }

    public static long ntoh(long l) {
        return Memory.bswap(l);
    }

    public static int hton(int n) {
        return Memory.bswap(n);
    }

    public static short hton(short s) {
        return Memory.bswap(s);
    }

    public static char hton(char c) {
        return Memory.bswap(c);
    }

    public static long hton(long l) {
        return Memory.bswap(l);
    }

    public static void bytesToFloats(byte[] byArray, int n, float[] fArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            int n5 = ((byArray[n + 0] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
            fArray[n2] = Float.intBitsToFloat(n5);
            n += 4;
            ++n2;
        }
    }

    public static void bytesToDoubles(byte[] byArray, int n, double[] dArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            long l = (((long)byArray[n + 0] & 0xFFL) << 56) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 7] & 0xFFL) << 0);
            dArray[n2] = Double.longBitsToDouble(l);
            n += 8;
            ++n2;
        }
    }

    public static void floatsToBytes(float[] fArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            int n5 = Float.floatToIntBits(fArray[n]);
            byArray[n2++] = (byte)(n5 >> 24 & 0xFF);
            byArray[n2++] = (byte)(n5 >> 16 & 0xFF);
            byArray[n2++] = (byte)(n5 >> 8 & 0xFF);
            byArray[n2++] = (byte)(n5 >> 0 & 0xFF);
            ++n;
        }
    }

    public static void doublesToBytes(double[] dArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            long l = Double.doubleToLongBits(dArray[n]);
            byArray[n2++] = (byte)(l >> 56 & 0xFFL);
            byArray[n2++] = (byte)(l >> 48 & 0xFFL);
            byArray[n2++] = (byte)(l >> 40 & 0xFFL);
            byArray[n2++] = (byte)(l >> 32 & 0xFFL);
            byArray[n2++] = (byte)(l >> 24 & 0xFFL);
            byArray[n2++] = (byte)(l >> 16 & 0xFFL);
            byArray[n2++] = (byte)(l >> 8 & 0xFFL);
            byArray[n2++] = (byte)(l >> 0 & 0xFFL);
            ++n;
        }
    }

    public static int getArrayLength(Object object) {
        return Memory.getInt(object, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reserveDirectMemory(long l) {
        Class<Memory> clazz = Memory.class;
        synchronized (Memory.class) {
            if (maxDirectMemory < 0L) {
                String string = VM.getProperty("jrockit.directmemory.max");
                maxDirectMemory = string == null ? Long.MAX_VALUE : Long.parseLong(string);
            }
            if (l <= maxDirectMemory - reservedDirectMemory) {
                reservedDirectMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            GC.runNormalGc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            clazz = Memory.class;
            synchronized (Memory.class) {
                if (l > maxDirectMemory - reservedDirectMemory) {
                    throw new OutOfMemoryError("Direct buffer memory");
                }
                reservedDirectMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unreserveDirectMemory(long l) {
        Class<Memory> clazz = Memory.class;
        synchronized (Memory.class) {
            reservedDirectMemory -= l;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static long getReservedDirectMemory() {
        return reservedDirectMemory;
    }

    private static native int allocateMemoryInternal(int var0);

    public static int allocateMemory(int n) {
        int n2 = Memory.allocateMemoryInternal(n);
        if (n2 == 0) {
            throw new OutOfMemoryError();
        }
        return n2;
    }

    public static native int reallocateMemory(int var0, int var1);

    public static native void freeMemory(int var0);

    public static native void copyMemory(int var0, int var1, int var2);

    public static native void setMemory(int var0, int var1, int var2);

    public static native int pageSize();

    public static final int addressSize() {
        return 4;
    }

    public static final int objectHeaderSize() {
        return 8;
    }

    public static final int baseObjectSize() {
        return 8;
    }

    public static final int arrayHeaderSize() {
        return 16;
    }

    public static final int objectRefSize() {
        return BYTES_OBJECTREF;
    }

    public static native Object getLockToken(Object var0, int var1);

    public static native Object getObjectFromToken(Object var0);

    public static native int objectAsAddress(Object var0);

    public static int identityHashCode(Object object) {
        return object != null ? Locks.getPrimitiveHashCode(object) : 0;
    }

    public static native boolean arrayEqualsInner(char[] var0, char[] var1, int var2);

    public static native boolean arrayEqualsInner(byte[] var0, byte[] var1, int var2);

    @ForceInline
    public static boolean arrayEquals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = cArray.length;
        if (n != cArray2.length) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        return Memory.arrayEqualsInner(cArray, cArray2, n);
    }

    @ForceInline
    public static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        return Memory.arrayEqualsInner(byArray, byArray2, n);
    }
}

