/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.NoInline;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Allocator;
import jrockit.vm.Intrinsics;
import jrockit.vm.Memory;
import jrockit.vm.ObjectMonitor;
import jrockit.vm.RNI;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;
import jrockit.vm.VM;

public final class Locks
extends VM {
    private static final int THREAD_ACTIVE = 0;
    private static final int THREAD_WAITING = -1;
    private static final int THREAD_BLOCKED = -2;
    private static final int THREAD_SPINBLOCKED = -3;
    private static final int THREAD_STATE_RUNNABLE = 5;
    private static final int THREAD_STATE_SLEEPING = 225;
    private static final int THREAD_STATE_IN_OBJECT_WAIT = 401;
    private static final int THREAD_STATE_IN_OBJECT_WAIT_TIMED = 417;
    private static final int THREAD_STATE_PARKED = 657;
    private static final int THREAD_STATE_PARKED_TIMED = 673;
    private static final int THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1025;
    private static final int INITIAL_MON_SIZE = 16;
    private static final int MAX_MONITOR_INDEX = 0x3FFFFF;
    private static ObjectMonitor[] monitors = new ObjectMonitor[16];
    private static int[] freeMonitors = new int[16];
    private static int maxUsedMonitor = 0;
    private static int nFreeMonitors = 0;
    private static Object monitorLock = new Object();
    private static boolean threadContentionMonitoringIsEnabled = false;
    private static final int CHECKLAZY_NOT_UNLOCKED = 0;
    private static final int CHECKLAZY_UNLOCKED_BY_SUSPEND = 1;
    private static final int CHECKLAZY_UNLOCKED_CHEAP = 2;
    private static int numLazyReverts = 0;

    public static native void monitorEnterUnmatched(Object var0);

    public static native void monitorExitUnmatched(Object var0);

    private static native void convertThinLockedToFatLocked(Object var0);

    private static native void convertFatLockedToThinLocked(Object var0);

    private static native void profMonitorWait(Object var0, long var1);

    private static native void profMonitorWaited(Object var0, boolean var1);

    private static native void profMonitorContendedEnter(Object var0);

    private static native void profMonitorContendedEntered(Object var0);

    private static native void reportFatalMonitorOverflowError(int var0, int var1);

    public static boolean monitorEnterForced(Object object) throws Throwable {
        Object object2 = Locks.monitorEnter(object);
        return (Memory.objectAsAddress(object2) & 7) != 5;
    }

    public static void monitorExitForced(Object object) throws Throwable {
        if ((Memory.getInt(object, 4) & 1) == 1) {
            Locks.unlockFat(object, Threads.getCurrentVMThread(), Locks.getMonitorAndReserve(object));
        } else {
            Locks.monitorExit(Memory.getLockToken(object, 1));
        }
    }

    private static int getThinLockOwner(Object object) {
        short s = Memory.getShort(object, 4);
        if ((s & 1) == 0) {
            return s & 0xFFFC;
        }
        return -1;
    }

    private static void waitForSpinLockRelease(Object object) {
        while (true) {
            if (VM.isSMP) {
                for (int i = VM.monitorContendedPollCount; i > 0; --i) {
                    for (int j = VM.monitorContendedSpinCount; j > 0; --j) {
                        Intrinsics.microPause();
                    }
                    if ((Memory.getInt(object, 4) & 1) != 0) continue;
                    return;
                }
            } else if ((Memory.getInt(object, 4) & 1) == 0) {
                return;
            }
            Threads.yield();
        }
    }

    private static void spinLockEnter(Object object) {
        int n;
        int n2;
        int n3;
        while ((n3 = Memory.getInt(object, 4) & 0xFFFFFFFE) != (n2 = Memory.cas(object, 4, n3, n = n3 | 1))) {
            Locks.waitForSpinLockRelease(object);
        }
        return;
    }

    private static void spinLockExit(Object object) {
        short s = Memory.getShort(object, 4);
        s = (short)(s & 0xFFFFFFFE);
        Intrinsics.membar(0);
        Memory.setShort(object, 4, s);
    }

    private static void releaseMonitorReservation(Object object) {
        short s = Memory.getShort(object, 4);
        s = (short)(s & 0xFFFFFFFD);
        Intrinsics.membar(0);
        Memory.setShort(object, 4, s);
    }

    private static void checkThreadStopException(Thread thread) throws Throwable {
        Object object = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object != thread) {
            throw (Throwable)object;
        }
    }

    public static boolean isMonitorReserved(Object object) {
        int n = Memory.getInt(object, 4);
        return (n & 3) == 3;
    }

    public static void waitForMonitorRelease(Object object) {
        while (true) {
            if (VM.isSMP) {
                for (int i = VM.monitorContendedPollCount; i > 0; --i) {
                    for (int j = VM.monitorContendedSpinCount; j > 0; --j) {
                        Intrinsics.microPause();
                    }
                    if (Locks.isMonitorReserved(object)) continue;
                    return;
                }
            } else if (!Locks.isMonitorReserved(object)) {
                return;
            }
            Threads.yield();
        }
    }

    private static ObjectMonitor getMonitorAndReserve(Object object) {
        boolean bl = false;
        while (true) {
            int n;
            int n2;
            int n3 = Memory.getInt(object, 4);
            int n4 = (n3 & 0xFFFFFC) >>> 2;
            if ((n3 & 1) != 1) {
                return null;
            }
            if ((n3 &= 0xFFFFFFFD) == (n2 = Memory.cas(object, 4, n3, n = n3 | 2))) {
                if (VM.lockProfilingEnabled) {
                    int n5 = Reflect.IClassBlock.getCB(object);
                    if (bl) {
                        Reflect.IClassBlock.incrLockCounter(n5, Reflect.offset(2570));
                    } else {
                        Reflect.IClassBlock.incrLockCounter(n5, Reflect.offset(2569));
                    }
                }
                ObjectMonitor objectMonitor = monitors[n4];
                Intrinsics.prefetch(objectMonitor);
                return objectMonitor;
            }
            Locks.waitForMonitorRelease(object);
            if (!VM.lockProfilingEnabled) continue;
            bl = true;
        }
    }

    public static boolean isThinLocked(Object object) {
        short s = Memory.getShort(object, 4);
        return (s & 1) != 1 && (s & 0xFFFC) != 0;
    }

    public static boolean isLockPotentiallyReserved(Object object) {
        int n = Memory.getInt(object, 4);
        return (n & 1) == 0 && (n & 0xFFFC) != 0 && (n & 0x10000) == 0;
    }

    private static native int checkAndTransferLazyLocked(Object var0);

    private static native int getNumberOfLocks(Object var0);

    private static native void javaLockDoCooperativeUnlock();

    private static native void lazyRevertNotify();

    private static native boolean checkIfThreadOwnsLock(Object var0);

    public static int waitForThinRelease(Object object, int n) {
        while (true) {
            int n2;
            int n3;
            if (VM.useLazyUnlocking && Locks.isLockPotentiallyReserved(object)) {
                n3 = Locks.checkAndTransferLazyLocked(object);
                if (VM.lazyUnlockingRevertNotifyInterval != 0 && ++numLazyReverts >= VM.lazyUnlockingRevertNotifyInterval) {
                    Locks.lazyRevertNotify();
                    numLazyReverts = 0;
                }
                if (VM.lockProfilingEnabled) {
                    n2 = Reflect.IClassBlock.getCB(object);
                    if (n3 == 1) {
                        Reflect.IClassBlock.incrLockCounter(n2, Reflect.offset(2571));
                    } else if (n3 == 2) {
                        Reflect.IClassBlock.incrLockCounter(n2, Reflect.offset(2572));
                    }
                }
            }
            if (!Locks.isThinLocked(object)) {
                return n;
            }
            if (VM.isSMP && n > 0) {
                for (n3 = VM.thinLockContendedPollCount; n3 > 0; --n3) {
                    for (n2 = VM.thinLockContendedSpinCount; n2 > 0; --n2) {
                        Intrinsics.microPause();
                    }
                    if (Locks.isThinLocked(object)) continue;
                    return n;
                }
            }
            if (n > 0) {
                Threads.yield();
            } else {
                n3 = -n / 2 + 1;
                Threads.sleep(n3 > 20 ? 20 : n3);
            }
            --n;
        }
    }

    public static Object monitorEnterSecondStage(Object object, int n) throws Throwable {
        if (VM.useLazyUnlocking && Locks.isLockPotentiallyReserved(object)) {
            Object object2;
            int n2 = Locks.checkAndTransferLazyLocked(object);
            if (VM.lazyUnlockingRevertNotifyInterval != 0 && ++numLazyReverts >= VM.lazyUnlockingRevertNotifyInterval) {
                Locks.lazyRevertNotify();
                numLazyReverts = 0;
            }
            if (VM.lockProfilingEnabled) {
                int n3 = Reflect.IClassBlock.getCB(object);
                if (n2 == 1) {
                    Reflect.IClassBlock.incrLockCounter(n3, Reflect.offset(2571));
                } else if (n2 == 2) {
                    Reflect.IClassBlock.incrLockCounter(n3, Reflect.offset(2572));
                }
            }
            if (n2 != 0 && (object2 = Locks.lockThin(object, false)) != null) {
                return object2;
            }
        }
        return Locks.monitorEnterSecondStageHard(object, n);
    }

    public static Object monitorEnterSecondStageHard(Object object, int n) throws Throwable {
        long l;
        long l2;
        int n2;
        long l3;
        boolean bl = false;
        int n3 = Threads.getCurrentVMThread();
        Thread thread = Threads.getThread(n3);
        Object object2 = null;
        int n4 = VM.thinLockConvertToFatThreshold;
        long l4 = 0L;
        boolean bl2 = false;
        int n5 = 0;
        Threads.setBlockingOnObject(thread, object);
        Threads.setThreadStatus(thread, 1025);
        if (VM.profMonitors) {
            Locks.profMonitorContendedEnter(object);
        }
        boolean bl3 = Memory.getByte((int)VM.javaLockEnterControl, 9) != 0;
        long l5 = l3 = bl3 ? RNI.counterTime() : 0L;
        while (true) {
            ObjectMonitor objectMonitor;
            if ((n & 1) == 1 && (objectMonitor = Locks.getMonitorAndReserve(object)) != null) {
                int n6;
                if (objectMonitor.lockLast != null && (n6 = Threads.getVMThread(objectMonitor.lockLast)) != 0) {
                    n5 = Threads.getThreadIndex(n6);
                }
                if (n5 == 0) {
                    n5 = objectMonitor.currentTIdx;
                }
                if ((object2 = Locks.lockFat(object, n3, objectMonitor, bl2)) != null) break;
            }
            if ((n & 0xFFFC) != Threads.getThreadIndex(n3) << 0) {
                Threads.setBlockingOnThreadIdx(thread, (n & 0xFFFC) >> 0);
                if (!bl2) {
                    Threads.incrementMonitorBlockedCount(n3);
                    bl2 = true;
                }
                if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                    l4 = System.currentTimeMillis();
                }
                n4 = Locks.waitForThinRelease(object, n4);
                n = Memory.getInt(object, 4);
                if ((n & 1) == 1) continue;
                if (n4 <= 0) {
                    bl = true;
                }
                if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l4 > 0L) {
                    l4 = System.currentTimeMillis() - l4;
                    Threads.incrementMonitorBlockedTime(n3, l4);
                    l4 = 0L;
                }
            }
            if ((object2 = Locks.lockThin(object, true)) != null) {
                if (!bl) break;
                try {
                    Locks.createMonitor(object, false);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    break;
                }
                if (Memory.objectAsAddress(object2) == Memory.objectAsAddress(object)) break;
                object2 = Memory.getLockToken(object, 6);
                break;
            }
            n = Memory.getInt(object, 4);
        }
        if (bl3 && (n2 = Threads.getBlockingOnThreadIdx(thread)) != 0 && (l2 = RNI.counterTime()) - l3 >= (l = Memory.getLong((int)VM.javaLockEnterControl, 0))) {
            RNI.jfrMonitorEnter(l3, l2, n2, Threads.getBlockingOnObject(thread));
        }
        Threads.setThreadStatus(thread, 5);
        Threads.setBlockingOnObject(thread, null);
        Threads.setBlockingOnThreadIdx(thread, 0);
        if (VM.profMonitors) {
            Locks.profMonitorContendedEntered(object);
        }
        return object2;
    }

    public static void monitorExitSecondStage(Object object) throws Throwable {
        Object object2 = Memory.getObjectFromToken(object);
        if ((Memory.objectAsAddress(object) & 7) == 6) {
            Locks.unlockFat(object2, Threads.getCurrentVMThread(), Locks.getMonitorAndReserve(object2));
        } else {
            Locks.monitorExitUnmatched(object2);
        }
    }

    public static ObjectMonitor createMonitor(Object object, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = -1;
        ObjectMonitor objectMonitor = new ObjectMonitor(object);
        Locks.spinLockEnter(monitorLock);
        do {
            if (nFreeMonitors == 0) {
                if (maxUsedMonitor == monitors.length) {
                    if (maxUsedMonitor + 1 > 0x3FFFFF) {
                        Locks.reportFatalMonitorOverflowError(maxUsedMonitor, 0x3FFFFF);
                    }
                    n3 = monitors.length;
                    Locks.spinLockExit(monitorLock);
                    ObjectMonitor[] objectMonitorArray = new ObjectMonitor[n3 * 2];
                    Locks.spinLockEnter(monitorLock);
                    if (monitors.length != n3) continue;
                    System.arraycopy(monitors, 0, objectMonitorArray, 0, n3);
                    monitors = objectMonitorArray;
                }
                n4 = maxUsedMonitor++;
                continue;
            }
            n4 = freeMonitors[--nFreeMonitors];
        } while (n4 == -1);
        Locks.monitors[n4] = objectMonitor;
        Locks.spinLockExit(monitorLock);
        objectMonitor.currentTIdx = Threads.getThreadIndex(Threads.getCurrentVMThread());
        objectMonitor.mIndex = n4;
        objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
        while ((n2 = Memory.cas(object, 4, n3 = Memory.getInt(object, 4), n = n3 & 0xFF000000 | n4 << 2 | 1 | (bl ? 2 : 0))) != n3) {
        }
        return objectMonitor;
    }

    private static ObjectMonitor createMonitorAndConvert(Object object, boolean bl) {
        ObjectMonitor objectMonitor = Locks.createMonitor(object, bl);
        Locks.convertThinLockedToFatLocked(object);
        return objectMonitor;
    }

    private static void deflateFatLockAndUnlock(Object object) {
        int n;
        int n2;
        int n3;
        do {
            n2 = Memory.getInt(object, 4);
            n = n2 & 0xFF000000;
            if (VM.useLazyUnlocking) {
                n |= 0x10000;
            }
            Intrinsics.membar(0);
        } while ((n3 = Memory.cas(object, 4, n2, n)) != n2);
    }

    static void releaseMonitor(ObjectMonitor objectMonitor) {
        int n = objectMonitor.mIndex;
        Thread thread = Thread.currentThread();
        Locks.spinLockEnter(monitorLock);
        if (monitors[n] != objectMonitor) {
            Locks.spinLockExit(monitorLock);
            return;
        }
        Locks.monitors[n] = null;
        while (nFreeMonitors == freeMonitors.length) {
            int n2 = freeMonitors.length;
            Locks.spinLockExit(monitorLock);
            int[] nArray = new int[n2 * 2];
            Locks.spinLockEnter(monitorLock);
            if (freeMonitors.length != n2 || nFreeMonitors != n2) continue;
            System.arraycopy(freeMonitors, 0, nArray, 0, n2);
            freeMonitors = nArray;
        }
        Locks.freeMonitors[Locks.nFreeMonitors] = n;
        ++nFreeMonitors;
        Locks.spinLockExit(monitorLock);
    }

    private static ObjectMonitor getMonitorWithCheck(Object object, boolean bl) throws IllegalMonitorStateException {
        ObjectMonitor objectMonitor = Locks.getMonitorAndReserve(object);
        int n = Threads.getThreadIndex(Threads.getCurrentVMThread());
        boolean bl2 = false;
        if (objectMonitor != null && objectMonitor.currentTIdx == n) {
            bl2 = true;
            if (!bl) {
                Locks.releaseMonitorReservation(object);
            }
        } else if (objectMonitor == null && Locks.getThinLockOwner(object) == n) {
            bl2 = true;
            if (VM.useLazyUnlocking && (Memory.getInt(object, 4) & 0x10000) == 0) {
                bl2 = Locks.checkIfThreadOwnsLock(object);
            }
        }
        if (!bl2) {
            if (objectMonitor != null) {
                Locks.releaseMonitorReservation(object);
            }
            throw new IllegalMonitorStateException("(m=" + objectMonitor + ") Failed to get monitor for (tIdx=" + Integer.toHexString(n) + ")");
        }
        return objectMonitor;
    }

    public static boolean fatLockBlockOrSpin(int n, ObjectMonitor objectMonitor, int n2, int n3) {
        boolean bl;
        if (n3 == -3) {
            if (n2 < VM.numCPUs) {
                n3 = Locks.fatLockSpin(n);
            } else {
                Threads.yield();
                n3 = Threads.getLockState(n);
            }
        }
        if (n3 != 0 && (bl = n3 == -2 ? true : Threads.changeLockState(n, n3, -2))) {
            if (VM.useAdaptiveFatSpin) {
                objectMonitor.doNotSpin = true;
            }
            Threads.waitForUnblockSignal();
            return true;
        }
        return false;
    }

    public static Object lockFat(Object object, int n, ObjectMonitor objectMonitor, boolean bl) throws Throwable {
        int n2 = Threads.getThreadIndex(n);
        Thread thread = Threads.getThread(n);
        if (objectMonitor.currentTIdx == n2) {
            Locks.releaseMonitorReservation(object);
            if (VM.lockProfilingEnabled) {
                int n3 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrLockCounter(n3, Reflect.offset(2567));
            }
            return Memory.getLockToken(object, 5);
        }
        if (objectMonitor.currentTIdx == 0 && (objectMonitor.lastHolderTIdx == 0 || objectMonitor.lastHolderTIdx == n2)) {
            objectMonitor.currentTIdx = n2;
            if (VM.lockProfilingEnabled) {
                int n4 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrLockCounter(n4, Reflect.offset(2565));
            }
            Locks.releaseMonitorReservation(object);
        } else {
            boolean bl2;
            long l = 0L;
            Threads.setBlockingOnThreadIdx(thread, objectMonitor.currentTIdx);
            boolean bl3 = bl2 = Threads.getBlockThreadStop(thread) == null;
            if (bl2) {
                Threads.setBlockThreadStop(thread, thread);
            }
            if (objectMonitor.lockLast != null) {
                Threads.setLockNext(objectMonitor.lockLast, thread);
            } else {
                objectMonitor.lockQueue = thread;
            }
            objectMonitor.lockLast = thread;
            int n5 = VM.useLockQueueLength ? objectMonitor.lockQueueLength++ : 1;
            int n6 = VM.useFatSpin ? (VM.useAdaptiveFatSpin ? (objectMonitor.doNotSpin ? -2 : -3) : -3) : -2;
            Threads.setLockState(n, n6);
            Locks.releaseMonitorReservation(object);
            if (!bl) {
                Threads.incrementMonitorBlockedCount(n);
                bl = true;
            }
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                l = System.currentTimeMillis();
            }
            boolean bl4 = Locks.fatLockBlockOrSpin(n, objectMonitor, n5, n6);
            objectMonitor = Locks.fatLockReacquire(object, thread);
            if (objectMonitor == null) {
                if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
                    l = System.currentTimeMillis() - l;
                    Threads.incrementMonitorBlockedTime(n, l);
                }
                if (bl2) {
                    Locks.checkThreadStopException(thread);
                }
                return null;
            }
            Locks.releaseMonitorReservation(object);
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
                l = System.currentTimeMillis() - l;
                Threads.incrementMonitorBlockedTime(n, l);
            }
            if (VM.lockProfilingEnabled) {
                int n7 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrLockCounter(n7, Reflect.offset(2566));
                if (bl4) {
                    Reflect.IClassBlock.incrLockCounter(n7, Reflect.offset(2568));
                }
            }
            if (bl2) {
                Object object2 = Threads.getBlockThreadStop(thread);
                if (object2 != thread) {
                    Locks.unlockFatInternal(object, n, objectMonitor, true);
                    Threads.setBlockThreadStop(thread, null);
                    throw (Throwable)object2;
                }
                Threads.setBlockThreadStop(thread, null);
            }
        }
        return Memory.getLockToken(object, 6);
    }

    private static int fatLockSpin(int n) {
        int n2 = Threads.getLockState(n);
        for (int i = VM.fatLockContendedPollCount; i > 0 && n2 != 0; --i) {
            for (int j = VM.fatLockContendedSpinCount; j > 0; --j) {
                Intrinsics.microPause();
            }
            n2 = Threads.getLockState(n);
        }
        return n2;
    }

    private static ObjectMonitor fatLockReacquire(Object object, Thread thread) {
        int n = Threads.getVMThread(thread);
        int n2 = Threads.getThreadIndex(n);
        ObjectMonitor objectMonitor = Locks.getMonitorAndReserve(object);
        if (objectMonitor == null) {
            return objectMonitor;
        }
        if (objectMonitor.currentTIdx != 0) {
            Threads.setBlockingOnThreadIdx(thread, objectMonitor.currentTIdx);
        }
        while (objectMonitor.currentTIdx != 0) {
            Threads.setLockNext(thread, objectMonitor.lockQueue);
            objectMonitor.lockQueue = thread;
            if (objectMonitor.lockLast == null) {
                objectMonitor.lockLast = thread;
            }
            if (VM.useLockQueueLength) {
                ++objectMonitor.lockQueueLength;
            }
            objectMonitor.lastHolderTIdx = n2;
            int n3 = VM.useFatSpin ? (!VM.reacquireShouldAlwaysSpin && VM.useAdaptiveFatSpin ? (objectMonitor.doNotSpin ? -2 : -3) : -3) : -2;
            Threads.setLockState(n, n3);
            Locks.releaseMonitorReservation(object);
            Locks.fatLockBlockOrSpin(n, objectMonitor, 1, n3);
            objectMonitor = Locks.getMonitorAndReserve(object);
            if (objectMonitor != null) continue;
            return objectMonitor;
        }
        objectMonitor.currentTIdx = n2;
        return objectMonitor;
    }

    public static void unlockFat(Object object, int n, ObjectMonitor objectMonitor) throws Throwable {
        Thread thread = Threads.getThread(n);
        Threads.setBlockThreadStop(thread, thread);
        Locks.unlockFatInternal(object, n, objectMonitor, true);
        Locks.checkThreadStopException(thread);
    }

    public static void unlockFatInternal(Object object, int n, ObjectMonitor objectMonitor, boolean bl) {
        int n2 = Threads.getThreadIndex(n);
        objectMonitor.currentTIdx = 0;
        if (objectMonitor.lockQueue == null) {
            int n3;
            objectMonitor.lastHolderTIdx = 0;
            if (VM.useAdaptiveFatSpin) {
                objectMonitor.doNotSpin = false;
            }
            if (VM.useFatLockDeflation && objectMonitor.waitQueue == null && (n3 = --objectMonitor.fatLockDeflationCount) == 0) {
                Locks.deflateFatLockAndUnlock(object);
                Locks.releaseMonitor(objectMonitor);
                return;
            }
            Locks.releaseMonitorReservation(object);
        } else if (objectMonitor.lastHolderTIdx == n2) {
            objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
            Locks.releaseMonitorReservation(object);
        } else {
            objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
            objectMonitor.lastHolderTIdx = n2;
            Thread thread = objectMonitor.lockQueue;
            int n4 = Threads.getVMThread(thread);
            objectMonitor.lockQueue = Threads.getLockNext(thread);
            Threads.setLockNext(thread, null);
            if (objectMonitor.lockQueue == null) {
                objectMonitor.lockLast = null;
            }
            if (VM.useLockQueueLength) {
                --objectMonitor.lockQueueLength;
            }
            Locks.releaseMonitorReservation(object);
            int n5 = Threads.getLockState(n4);
            if (n5 == -3 && !Threads.changeLockState(n4, n5, 0)) {
                n5 = -2;
            }
            if (n5 == -2) {
                Threads.setLockState(n4, 0);
                Threads.signalWaiter(thread);
            }
        }
    }

    private static void notify(Object object) throws Throwable {
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, false);
        if (objectMonitor == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        Threads.setBlockThreadStop(thread, thread);
        Thread thread2 = objectMonitor.waitQueue;
        if (thread2 != null) {
            int n = Threads.getVMThread(thread2);
            objectMonitor.waitQueue = Threads.getWaitNext(thread2);
            if (objectMonitor.waitQueue == null) {
                objectMonitor.waitLast = null;
            }
            if (Threads.changeLockState(n, -1, -2)) {
                objectMonitor = Locks.getMonitorAndReserve(object);
                if (objectMonitor.lockLast != null) {
                    Threads.setLockNext(objectMonitor.lockLast, thread2);
                } else {
                    objectMonitor.lockQueue = thread2;
                }
                objectMonitor.lockLast = thread2;
                Threads.setNotifiedBy(thread2, Threads.getId(thread));
                Locks.releaseMonitorReservation(object);
            }
        }
        Locks.checkThreadStopException(thread);
    }

    private static void notifyAll(Object object) throws Throwable {
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, false);
        if (objectMonitor == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        Threads.setBlockThreadStop(thread, thread);
        Thread thread2 = objectMonitor.waitQueue;
        while (thread2 != null) {
            Thread thread3 = Threads.getWaitNext(thread2);
            int n = Threads.getVMThread(thread2);
            if (Threads.changeLockState(n, -1, -2)) {
                objectMonitor = Locks.getMonitorAndReserve(object);
                if (objectMonitor.lockLast != null) {
                    Threads.setLockNext(objectMonitor.lockLast, thread2);
                } else {
                    objectMonitor.lockQueue = thread2;
                }
                objectMonitor.lockLast = thread2;
                Threads.setNotifiedBy(thread2, Threads.getId(thread));
                Locks.releaseMonitorReservation(object);
            }
            thread2 = thread3;
        }
        objectMonitor.waitQueue = null;
        objectMonitor.waitLast = null;
        Locks.checkThreadStopException(thread);
    }

    private static void removeFromWaitQueue(ObjectMonitor objectMonitor, Thread thread) {
        if (objectMonitor == null) {
            return;
        }
        Thread thread2 = objectMonitor.waitQueue;
        if (thread2 == thread) {
            objectMonitor.waitQueue = Threads.getWaitNext(thread);
            if (objectMonitor.waitQueue == null) {
                objectMonitor.waitLast = null;
            }
            return;
        }
        while (thread2 != null) {
            Thread thread3 = Threads.getWaitNext(thread2);
            if (thread3 == thread) {
                Thread thread4 = Threads.getWaitNext(thread);
                Threads.setWaitNext(thread2, thread4);
                if (thread4 == null) {
                    objectMonitor.waitLast = thread2;
                }
                return;
            }
            thread2 = thread3;
        }
    }

    public static void wait(Object object, long l) throws Throwable {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Thread thread = Thread.currentThread();
        if (Threads.isInterrupted(thread, true)) {
            throw new InterruptedException();
        }
        int n = l == 0L ? 401 : 417;
        Threads.setThreadStatus(thread, n);
        if (VM.profMonitors) {
            Locks.profMonitorWait(object, l);
        }
        Threads.setBlockThreadStop(thread, thread);
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, true);
        int n2 = Threads.getVMThread(thread);
        if (objectMonitor == null) {
            try {
                objectMonitor = Locks.createMonitorAndConvert(object, true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Threads.setLockState(n2, 0);
                Threads.setThreadStatus(thread, 5);
                Threads.setCurrentWaitingObject(thread, null);
                if (VM.profMonitors) {
                    Locks.profMonitorWaited(object, false);
                }
                throw outOfMemoryError;
            }
        }
        Threads.setCurrentWaitingObject(thread, object);
        Threads.setNotifiedBy(thread, 0L);
        Threads.setLockState(n2, -1);
        try {
            if (Threads.getBlockThreadStop(thread) != thread) {
                Locks.checkThreadStopException(thread);
            }
            if (Threads.isInterrupted(thread, true)) {
                throw new InterruptedException("kaka1");
            }
        }
        catch (Throwable throwable) {
            Threads.setLockState(n2, 0);
            Threads.setThreadStatus(thread, 5);
            Threads.setCurrentWaitingObject(thread, null);
            Locks.releaseMonitorReservation(object);
            throw throwable;
        }
        Threads.setWaitNext(thread, null);
        if (objectMonitor.waitLast != null) {
            Threads.setWaitNext(objectMonitor.waitLast, thread);
        } else {
            objectMonitor.waitQueue = thread;
        }
        objectMonitor.waitLast = thread;
        Locks.unlockFatInternal(object, n2, objectMonitor, true);
        long l2 = 0L;
        Threads.incrementMonitorWaitedCount(n2);
        if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
            l2 = System.currentTimeMillis();
        }
        boolean bl = Threads.waitForNotifySignal(l, object);
        Threads.setCurrentWaitingObject(thread, null);
        objectMonitor = Locks.fatLockReacquire(object, thread);
        Threads.setBlockingOnThreadIdx(thread, 0);
        if (objectMonitor != null) {
            Locks.releaseMonitorReservation(object);
        }
        if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l2 > 0L) {
            l2 = System.currentTimeMillis() - l2;
            Threads.incrementMonitorWaitedTime(n2, l2);
        }
        if (!Threads.isNotified(thread)) {
            Locks.removeFromWaitQueue(objectMonitor, thread);
        }
        if (objectMonitor == null) {
            Object object2 = Locks.monitorEnterSecondStage(object, Memory.getInt(object, 4));
            int n3 = Memory.objectAsAddress(object2) & 7;
            if (n3 == 1 || n3 == 3) {
                Locks.convertFatLockedToThinLocked(object);
            } else if (VM.useLazyUnlocking && n3 == 5 && Locks.getNumberOfLocks(object) == 1) {
                Locks.convertFatLockedToThinLocked(object);
            }
        }
        Threads.setThreadStatus(thread, 5);
        if (VM.profMonitors) {
            Locks.profMonitorWaited(object, !bl);
        }
        Locks.checkThreadStopException(thread);
        if (Threads.isInterrupted(thread, true)) {
            throw new InterruptedException();
        }
    }

    public static void wait(Object object) throws Throwable {
        Locks.wait(object, 0L);
    }

    public static void wait(Object object, long l, int n) throws Throwable {
        Locks.wait(object, l);
    }

    @NoInline
    @NoSafePoint
    public static Object lockThin(Object object, boolean bl) {
        int n = Threads.getCurrentVMThread();
        int n2 = Threads.getThreadIndex(n) << 0;
        int n3 = Memory.getInt(object, 4);
        int n4 = n3 & 0xFFFF0000;
        int n5 = n4 | n2;
        if (VM.useLazyUnlocking && n3 == n5) {
            if (VM.lockProfilingEnabled) {
                int n6 = Reflect.IClassBlock.getCB(object);
                if (bl) {
                    Reflect.IClassBlock.incrLockCounter(n6, Reflect.offset(2563));
                } else if ((n3 & 0x10000) == 0) {
                    Reflect.IClassBlock.incrLockCounter(n6, Reflect.offset(2562));
                } else {
                    Reflect.IClassBlock.incrLockCounter(n6, Reflect.offset(2564));
                }
            }
            return Memory.getLockToken(object, 5);
        }
        n3 = Memory.cas(object, 4, n4, n5);
        if (n3 == n4) {
            if (VM.lazyUnlockingEnabledInJit && (n3 & 0x10000) == 0) {
                if (VM.lockProfilingEnabled) {
                    int n7 = Reflect.IClassBlock.getCB(object);
                    if (bl) {
                        Reflect.IClassBlock.incrLockCounter(n7, Reflect.offset(2563));
                    } else {
                        Reflect.IClassBlock.incrLockCounter(n7, Reflect.offset(2573));
                    }
                }
                return Memory.getLockToken(object, 5);
            }
            if (VM.lockProfilingEnabled) {
                int n8 = Reflect.IClassBlock.getCB(object);
                if (bl) {
                    Reflect.IClassBlock.incrLockCounter(n8, Reflect.offset(2563));
                } else {
                    Reflect.IClassBlock.incrLockCounter(n8, Reflect.offset(2561));
                }
            }
            return Memory.getLockToken(object, 1);
        }
        if (n3 == n5) {
            if (VM.lockProfilingEnabled) {
                int n9 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrLockCounter(n9, Reflect.offset(2564));
            }
            return Memory.getLockToken(object, 5);
        }
        return null;
    }

    @NoSafePoint
    @NoInline
    public static int getPrimitiveHashCode(Object object) {
        int n = Memory.getInt(object, 4) & 0xC0000000;
        if (n == Integer.MIN_VALUE) {
            return Memory.getInt(object, 4 - Allocator.OBJALIGN);
        }
        if (n == 0x40000000) {
            return Memory.objectAsAddress(object) >>> Allocator.OBJKCONSTANT;
        }
        return Locks.getPrimitiveHashCode0(object);
    }

    private static native int getPrimitiveHashCode0(Object var0);

    public static Object monitorEnter(Object object) throws Throwable {
        Object object2 = Locks.lockThin(object, false);
        if (object2 == null) {
            object2 = Locks.monitorEnterSecondStage(object, Memory.getInt(object, 4));
        }
        return object2;
    }

    @NoSafePoint
    public static void monitorExit(Object object) throws Throwable {
        int n = Memory.objectAsAddress(object) & 7;
        if (n == 1) {
            Intrinsics.membar(0);
            Memory.setShort(object, 3, (short)0);
        } else if (n != 5) {
            Locks.monitorExitSecondStage(object);
        }
    }

    public static void park(boolean bl, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        Thread thread = Thread.currentThread();
        if (Threads.isInterrupted(thread, false)) {
            return;
        }
        if (bl) {
            if ((l -= System.currentTimeMillis()) <= 0L) {
                return;
            }
        } else if (l != 0L && (l /= 1000000L) == 0L) {
            l = 1L;
        }
        Threads.setThreadStatus(thread, l == 0L ? 657 : 673);
        Locks.park0(l);
        Threads.setThreadStatus(thread, 5);
    }

    public static void unpark(Object object) {
        Locks.unpark0((Thread)object);
    }

    public static native void park0(long var0);

    public static native void unpark0(Thread var0);

    static {
        new IllegalMonitorStateException();
        new InterruptedException();
        new IllegalArgumentException();
    }
}

