/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.lang.ref.WeakReference;

final class FCECache {
    private final FCE[] cacheVec1;
    private final FCE[] cacheVec2;
    private final int cacheSize1;
    private final int cacheSize2;
    private static volatile int shouldOverWriteFirstCacheCounter = 0;

    public FCECache(int n, int n2) {
        this.cacheSize1 = n;
        this.cacheSize2 = n2;
        this.cacheVec1 = new FCE[n];
        this.cacheVec2 = new FCE[n2];
    }

    public FCECache() {
        this(211, 113);
    }

    public FCEEntry find(ClassLoader classLoader, String string) {
        Class clazz = null;
        boolean bl = true;
        int n = string.hashCode();
        int n2 = classLoader == null ? 0 : classLoader.hashCode();
        int n3 = n + n2 & Integer.MAX_VALUE;
        int n4 = n3 % this.cacheSize1;
        int n5 = 0;
        FCE fCE = this.cacheVec1[n4];
        if (fCE != null) {
            ClassLoader classLoader2 = fCE.getLoader();
            Class clazz2 = fCE.getClazz();
            if (!fCE.valid) {
                this.cacheVec1[n4] = null;
            } else if (classLoader2 == classLoader && clazz2.getName().equals(string)) {
                clazz = clazz2;
            } else {
                n5 = (2 * n3 + 100 & Integer.MAX_VALUE) % this.cacheSize2;
                fCE = this.cacheVec2[n5];
                if (fCE != null) {
                    classLoader2 = fCE.getLoader();
                    clazz2 = fCE.getClazz();
                    if (!fCE.valid) {
                        this.cacheVec2[n5] = null;
                    } else if (classLoader2 == classLoader && clazz2.getName().equals(string)) {
                        clazz = clazz2;
                    }
                }
                if (clazz == null) {
                    if (shouldOverWriteFirstCacheCounter++ < 17) {
                        n4 = -1;
                    } else {
                        shouldOverWriteFirstCacheCounter = 0;
                    }
                }
            }
        }
        return new FCEEntry(n4, n5, clazz);
    }

    private static final class FCE {
        final WeakReference weakClassLoader;
        final WeakReference weakClass;
        boolean valid;

        public FCE(ClassLoader classLoader, Class clazz) {
            this.weakClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
            this.weakClass = new WeakReference<Class>(clazz);
            this.valid = true;
        }

        public ClassLoader getLoader() {
            if (this.weakClassLoader == null) {
                return null;
            }
            ClassLoader classLoader = (ClassLoader)this.weakClassLoader.get();
            this.valid &= classLoader != null;
            return classLoader;
        }

        public Class getClazz() {
            Class clazz = (Class)this.weakClass.get();
            this.valid &= clazz != null;
            return clazz;
        }
    }

    public final class FCEEntry {
        private int pos1;
        private int pos2;
        private Class c;

        public FCEEntry(int n, int n2, Class clazz) {
            this.pos1 = n;
            this.pos2 = n2;
            this.c = clazz;
        }

        public Class get() {
            return this.c;
        }

        public void set(ClassLoader classLoader, Class clazz) {
            if (this.pos1 != -1) {
                ((FCECache)FCECache.this).cacheVec1[this.pos1] = new FCE(classLoader, clazz);
            } else {
                ((FCECache)FCECache.this).cacheVec2[this.pos2] = new FCE(classLoader, clazz);
            }
        }
    }
}

