/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.io.PrintWriter;
import java.io.StringWriter;
import jrockit.annotations.Internal;
import jrockit.annotations.ThrowCycle;
import jrockit.vm.Reflect;

@Internal
public final class ExceptionHandler {
    private ExceptionHandler() {
    }

    @ThrowCycle
    private static native void throwPendingType();

    @ThrowCycle
    private static native Throwable enterExceptionHandler();

    @ThrowCycle
    public static native void throwException(Throwable var0);

    @ThrowCycle
    private static native void gotoHandler();

    @ThrowCycle
    private static native void throwMissingCDPReference(int var0, int var1, int var2);

    @ThrowCycle
    private static void throwClassCastException(int n, int n2) {
        throw new ClassCastException(Reflect.IClassBlock.getClass(n).getName());
    }

    @ThrowCycle
    private static void throwIncompatibleClassChangeError(int n) {
        throw new IncompatibleClassChangeError(Reflect.IClass.get(n).getName());
    }

    @ThrowCycle
    private static native void throwIllegalAccessError(int var0);

    @ThrowCycle
    private static void throwArrayIndexOutOfBoundsException(int n) {
        throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
    }

    @ThrowCycle
    private static void throwClassCastToArrayException() {
        throw new ClassCastException("Class cannot be casted to array");
    }

    @ThrowCycle
    private static void throwInstantiationError(int n) {
        throw new InstantiationError(Reflect.IClass.get(n).getName());
    }

    @ThrowCycle
    private static void throwFinalFieldAssignedError() {
        throw new IncompatibleClassChangeError("Tried to assign final field");
    }

    private static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

