/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import jrockit.annotations.ImmutableLoad;
import jrockit.annotations.Internal;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Intrinsics;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;

public class Allocator {
    static final int CLEAR_ON_ALLOC = 0;
    static final int CLEAR_CHUNKS = 1;
    static final int CLEAR_TLAS = 2;
    static int TLA_WASTE_LIMIT;
    static int PREFETCH_SIZE;
    static int PREFETCH_DISTANCE;
    static boolean REDO_SOME_PREFETCHING;
    static boolean USE_PREFETCHING;
    static int CHUNK_SIZE;
    static int CLEAR_TYPE;
    static int OBJALIGN;
    static int OBJKCONSTANT;
    static boolean jvmtiVMObjectAllocs;
    private static boolean memleakObjectAllocs;
    private static long memleakCounterAddress;
    private static long memleakClassName;
    private static int memleakFrequency;
    private static Object dummyObject1;
    private static Object dummyObject2;

    private Allocator() {
    }

    private static native void registerFinalizer(Object var0);

    private static void dummyUsage(Class clazz) {
        if (clazz == dummyObject1) {
            dummyObject2 = clazz;
        }
    }

    @Internal
    private static void memleakBacktrace(Object object) {
        int n = Memory.getInt((int)memleakCounterAddress);
        if (n == 0) {
            Allocator.memleakBacktrace0();
        }
        if (n++ >= memleakFrequency) {
            n = 0;
        }
        Memory.setInt((int)memleakCounterAddress, n);
    }

    @Internal
    private static void checkedMemleakBacktrace(long l) {
        if (Reflect.IClass.getIName((int)l) == (int)memleakClassName) {
            Allocator.memleakBacktrace(null);
        }
    }

    public static Object allocObject(Class clazz) {
        int n = Reflect.IClass.getID(clazz);
        Object object = Allocator.allocObject(n);
        Allocator.dummyUsage(clazz);
        if (jvmtiVMObjectAllocs) {
            Allocator.jvmtiVMObjectAlloc(object);
        }
        if (memleakObjectAllocs) {
            Allocator.checkedMemleakBacktrace(n);
        }
        if (Reflect.IClass.hasFinalizer(n)) {
            Allocator.registerFinalizer(object);
        }
        return object;
    }

    public static Object allocArray(Class clazz, int n) {
        int n2 = Reflect.IClass.getID(clazz);
        Object object = Allocator.allocArray(n2, n, true);
        Allocator.dummyUsage(clazz);
        if (jvmtiVMObjectAllocs) {
            Allocator.jvmtiVMObjectAlloc(object);
        }
        if (memleakObjectAllocs) {
            Allocator.checkedMemleakBacktrace(n2);
        }
        return object;
    }

    public static Object allocMultiArray(Class clazz, int[] nArray) {
        return Allocator.allocMultiArray(Reflect.IClass.getID(clazz), nArray, 0);
    }

    public static Object allocMultiArray(int n, int[] nArray, int n2) {
        int n3 = nArray[n2++];
        Object object = Allocator.allocArray(n, n3, true);
        if (n2 < nArray.length) {
            for (int i = 0; i < n3; ++i) {
                ((Object[])object)[i] = Allocator.allocMultiArray(Reflect.IClass.getInnerType(n), nArray, n2);
            }
        }
        return object;
    }

    private static Object allocMultiArray(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new InternalError();
        }
        int n4 = n3;
        int n5 = Memory.addressSize();
        int n6 = 0;
        while (n6 < n2) {
            int n7 = Memory.getAddress(n4);
            if (n7 < 0) {
                throw new NegativeArraySizeException();
            }
            ++n6;
            n4 += n5;
        }
        return Allocator.allocMultiArray(n, n2, n3, n5);
    }

    private static Object allocMultiArray(int n, int n2, int n3, int n4) {
        int n5 = Memory.getAddress(n3);
        Object object = Allocator.allocArray(n, n5, true);
        if (n2 > 1) {
            int n6 = Reflect.IClass.getInnerType(n);
            --n2;
            n3 += n4;
            for (int i = 0; i < n5; ++i) {
                ((Object[])object)[i] = Allocator.allocMultiArray(n6, n2, n3);
            }
        }
        return object;
    }

    private static Object alloc2DimArray(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new NegativeArraySizeException();
        }
        Object[] objectArray = (Object[])Allocator.allocArray(n, n2, true);
        int n4 = Reflect.IClass.getInnerType(n);
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = Allocator.allocArray(n4, n3, true);
        }
        return objectArray;
    }

    private static Object allocObject(int n) {
        int n2 = Reflect.IClassBlock.getCB(n);
        int n3 = Reflect.IClass.getInstanceSize(n);
        return Allocator.allocObjectOrArray(n2, n3, -1, true);
    }

    private static Object allocArray(int n, int n2, boolean bl) {
        if (n2 < 0) {
            throw new NegativeArraySizeException();
        }
        if (n2 >= 0xFFFFFEF - OBJALIGN) {
            return Allocator.allocLargeObjectOrArray(Reflect.IClassBlock.getCB(n), n2, bl);
        }
        int n3 = Reflect.IClassBlock.getCB(n);
        int n4 = Reflect.IClass.getInstanceSize(n);
        int n5 = n4 * n2 + 16;
        n5 = n5 + OBJALIGN - 1 & -OBJALIGN;
        return Allocator.allocObjectOrArray(n3, n5, n2, bl);
    }

    @NoSafePoint
    private static Object allocObjectOrArray(int n, int n2, int n3, boolean bl) {
        while (true) {
            int n4;
            int n5;
            int n6 = Allocator.getTLAInfo();
            int n7 = Allocator.getTLAMarker(n6);
            int n8 = Allocator.getTLANextFree(n6);
            int n9 = n8 + n2;
            while (true) {
                int n10;
                int n11;
                if (!Intrinsics.cmpugt(n2, n5 = n7 - n8)) {
                    Allocator.setTLANextFree(n6, n9);
                    if (CLEAR_TYPE == 0 && bl) {
                        Allocator.memclear(n8, n2);
                    }
                    Allocator.writeObjectHeader(n8, n);
                    if (n3 >= 0) {
                        Memory.setInt(n8, 8, n3);
                    }
                    return Allocator.addressToObject(n8);
                }
                if (!USE_PREFETCHING && CLEAR_TYPE != 1 || Intrinsics.cmpugt(n2, n11 = (n4 = Allocator.getTLATop(n6)) - n8)) break;
                int n12 = 0;
                int n13 = n9 - n7;
                while (Intrinsics.cmpugt(n13, n12)) {
                    n12 += CHUNK_SIZE;
                }
                n11 = n4 - n7;
                if (Intrinsics.cmpugt(n12, n11)) {
                    n10 = n4;
                    n12 = n11;
                } else {
                    n10 = n7 + n12;
                }
                if (USE_PREFETCHING) {
                    Intrinsics.allocationPrefetch(n7, n10, n2);
                }
                if (CLEAR_TYPE == 1) {
                    Allocator.memclear(n7, n12);
                }
                n7 = n10;
                Allocator.setTLAMarker(n6, n7);
            }
            n5 = TLA_WASTE_LIMIT;
            if (Intrinsics.cmpugt(n2, n5)) {
                return Allocator.allocLargeObjectOrArray(n, n3, bl);
            }
            do {
                Allocator.getNewTla(n, n2);
            } while ((n4 = Allocator.getTLANextFree(n6)) == 0);
        }
    }

    private static native void getNewTla(int var0, int var1);

    @ImmutableLoad
    private static native void writeObjectHeader(int var0, int var1);

    private static native Object addressToObject(int var0);

    private static native int getTLAInfo();

    private static native int getTLATop(int var0);

    private static native int getTLANextFree(int var0);

    private static native int getTLAMarker(int var0);

    private static native void setTLANextFree(int var0, int var1);

    private static native void setTLAMarker(int var0, int var1);

    private static native void memclear(int var0, int var1);

    private static native Object allocLargeObjectOrArray(int var0, int var1, boolean var2);

    @Internal
    private static final native void jvmtiVMObjectAlloc(Object var0);

    @Internal
    private static final native void memleakBacktrace0();
}

