/*
 * Decompiled with CFR 0.152.
 */
package jrockit.proxy.java.lang.reflect;

import jrockit.annotations.Internal;
import jrockit.vm.Allocator;
import jrockit.vm.Classes;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Runtime;

@Internal
public final class Array {
    private static final boolean nullValueIsNullpointer = !Runtime.isJDK15OrBetter();

    private Array() {
    }

    private static Class getArrayClass(Class clazz, int n) {
        try {
            String string = clazz.getName();
            StringBuilder stringBuilder = new StringBuilder(string.length() + n + 5);
            while (n-- > 0) {
                stringBuilder.append('[');
            }
            if (clazz.isPrimitive()) {
                int n2;
                if (clazz == Boolean.TYPE) {
                    n2 = 90;
                } else if (clazz == Byte.TYPE) {
                    n2 = 66;
                } else if (clazz == Short.TYPE) {
                    n2 = 83;
                } else if (clazz == Character.TYPE) {
                    n2 = 67;
                } else if (clazz == Integer.TYPE) {
                    n2 = 73;
                } else if (clazz == Long.TYPE) {
                    n2 = 74;
                } else if (clazz == Float.TYPE) {
                    n2 = 70;
                } else if (clazz == Double.TYPE) {
                    n2 = 68;
                } else {
                    throw new IllegalArgumentException("cannot create array of " + string + " type");
                }
                stringBuilder.append((char)n2);
            } else if (clazz.isArray()) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append('L').append(string).append(';');
            }
            String string2 = stringBuilder.toString();
            return Classes.forName(string2, false, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException.getMessage());
        }
    }

    public static Object newInstance(Class<?> clazz, int n) throws NegativeArraySizeException {
        return Array.newArray(clazz, n);
    }

    public static Object newInstance(Class<?> clazz, int[] nArray) throws IllegalArgumentException, NegativeArraySizeException {
        return Array.multiNewArray(clazz, nArray);
    }

    private static void check(Object object) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("object is not an array");
        }
    }

    public static int getLength(Object object) throws IllegalArgumentException {
        Array.check(object);
        return Memory.getArrayLength(object);
    }

    public static Object get(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null) {
            if (!clazz.isPrimitive()) {
                return ((Object[])object)[n];
            }
            if (clazz == Integer.TYPE) {
                return new Integer(((int[])object)[n]);
            }
            if (clazz == Long.TYPE) {
                return new Long(((long[])object)[n]);
            }
            if (clazz == Byte.TYPE) {
                return new Byte(((byte[])object)[n]);
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(((boolean[])object)[n]);
            }
            if (clazz == Short.TYPE) {
                return new Short(((short[])object)[n]);
            }
            if (clazz == Character.TYPE) {
                return new Character(((char[])object)[n]);
            }
            if (clazz == Float.TYPE) {
                return new Float(((float[])object)[n]);
            }
            if (clazz == Double.TYPE) {
                return new Double(((double[])object)[n]);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean getBoolean(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            return ((boolean[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static byte getByte(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static char getChar(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Character.TYPE) {
            return ((char[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static short getShort(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Short.TYPE) {
            return ((short[])object)[n];
        }
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static int getInt(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Integer.TYPE) {
            return ((int[])object)[n];
        }
        if (clazz == Short.TYPE) {
            return ((short[])object)[n];
        }
        if (clazz == Character.TYPE) {
            return ((char[])object)[n];
        }
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static long getLong(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Long.TYPE) {
            return ((long[])object)[n];
        }
        if (clazz == Integer.TYPE) {
            return ((int[])object)[n];
        }
        if (clazz == Short.TYPE) {
            return ((short[])object)[n];
        }
        if (clazz == Character.TYPE) {
            return ((char[])object)[n];
        }
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static float getFloat(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Float.TYPE) {
            return ((float[])object)[n];
        }
        if (clazz == Integer.TYPE) {
            return ((int[])object)[n];
        }
        if (clazz == Long.TYPE) {
            return ((long[])object)[n];
        }
        if (clazz == Short.TYPE) {
            return ((short[])object)[n];
        }
        if (clazz == Character.TYPE) {
            return ((char[])object)[n];
        }
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static double getDouble(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Double.TYPE) {
            return ((double[])object)[n];
        }
        if (clazz == Long.TYPE) {
            return ((long[])object)[n];
        }
        if (clazz == Float.TYPE) {
            return ((float[])object)[n];
        }
        if (clazz == Integer.TYPE) {
            return ((int[])object)[n];
        }
        if (clazz == Short.TYPE) {
            return ((short[])object)[n];
        }
        if (clazz == Character.TYPE) {
            return ((char[])object)[n];
        }
        if (clazz == Byte.TYPE) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static void set(Object object, int n, Object object2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null && Reflect.IClass.isInvocationAssignable(clazz, object2)) {
            if (!clazz.isPrimitive()) {
                ((Object[])object)[n] = object2;
                return;
            }
            if (object2 instanceof Number) {
                if (clazz == Long.TYPE) {
                    ((long[])object)[n] = ((Number)object2).longValue();
                    return;
                }
                if (clazz == Integer.TYPE) {
                    ((int[])object)[n] = ((Number)object2).intValue();
                    return;
                }
                if (clazz == Double.TYPE) {
                    ((double[])object)[n] = ((Number)object2).doubleValue();
                    return;
                }
                if (clazz == Float.TYPE) {
                    ((float[])object)[n] = ((Number)object2).floatValue();
                    return;
                }
                if (clazz == Short.TYPE) {
                    ((short[])object)[n] = ((Number)object2).shortValue();
                    return;
                }
                if (clazz == Byte.TYPE) {
                    ((byte[])object)[n] = ((Number)object2).byteValue();
                    return;
                }
            } else if (object2 instanceof Character) {
                if (clazz == Character.TYPE) {
                    ((char[])object)[n] = ((Character)object2).charValue();
                    return;
                }
                if (clazz == Long.TYPE) {
                    ((long[])object)[n] = ((Character)object2).charValue();
                    return;
                }
                if (clazz == Integer.TYPE) {
                    ((int[])object)[n] = ((Character)object2).charValue();
                    return;
                }
                if (clazz == Double.TYPE) {
                    ((double[])object)[n] = ((Character)object2).charValue();
                    return;
                }
                if (clazz == Float.TYPE) {
                    ((float[])object)[n] = ((Character)object2).charValue();
                    return;
                }
            } else if (clazz == Boolean.TYPE && object2 != null) {
                ((boolean[])object)[n] = (Boolean)object2;
                return;
            }
        }
        if (nullValueIsNullpointer && object2 == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static void setBoolean(Object object, int n, boolean bl) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            ((boolean[])object)[n] = bl;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setByte(Object object, int n, byte by) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            ((byte[])object)[n] = by;
            return;
        }
        if (clazz == Short.TYPE) {
            ((short[])object)[n] = by;
            return;
        }
        if (clazz == Integer.TYPE) {
            ((int[])object)[n] = by;
            return;
        }
        if (clazz == Long.TYPE) {
            ((long[])object)[n] = by;
            return;
        }
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = by;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = by;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setChar(Object object, int n, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Character.TYPE) {
            ((char[])object)[n] = c;
            return;
        }
        if (clazz == Integer.TYPE) {
            ((int[])object)[n] = c;
            return;
        }
        if (clazz == Long.TYPE) {
            ((long[])object)[n] = c;
            return;
        }
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = c;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = c;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setShort(Object object, int n, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Short.TYPE) {
            ((short[])object)[n] = s;
            return;
        }
        if (clazz == Integer.TYPE) {
            ((int[])object)[n] = s;
            return;
        }
        if (clazz == Long.TYPE) {
            ((long[])object)[n] = s;
            return;
        }
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = s;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = s;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setInt(Object object, int n, int n2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Integer.TYPE) {
            ((int[])object)[n] = n2;
            return;
        }
        if (clazz == Long.TYPE) {
            ((long[])object)[n] = n2;
            return;
        }
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = n2;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = n2;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setLong(Object object, int n, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Long.TYPE) {
            ((long[])object)[n] = l;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = l;
            return;
        }
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = l;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setFloat(Object object, int n, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Float.TYPE) {
            ((float[])object)[n] = f;
            return;
        }
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = f;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setDouble(Object object, int n, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Double.TYPE) {
            ((double[])object)[n] = d;
            return;
        }
        throw new IllegalArgumentException();
    }

    private static Object newArray(Class clazz, int n) throws NegativeArraySizeException {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        return Allocator.allocArray(Array.getArrayClass(clazz, 1), n);
    }

    private static Object multiNewArray(Class clazz, int[] nArray) throws IllegalArgumentException, NegativeArraySizeException {
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("zero dimensions");
        }
        if (nArray.length > 255) {
            throw new IllegalArgumentException("too many dimensions");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new NegativeArraySizeException();
        }
        return Allocator.allocMultiArray(Array.getArrayClass(clazz, nArray.length), nArray);
    }
}

