/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import jrockit.vm.GC;

public class Finalizer {
    private Finalizer() {
    }

    private static native void runFinalizer(Object var0);

    private static void doFinalize(Object object) {
        try {
            if (!(object instanceof Enum)) {
                Finalizer.runFinalizer(object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static native Object getNextFinalizee(long var0);

    private static native int getFinalizeeArraySize(long var0);

    private static native int waitForFinalizees(long var0, Object[] var2);

    private static native Object getUnfinalizedFinalizee(long var0);

    private static native long createGlobalContext();

    private static native void destroyGlobalContext(long var0);

    private static ThreadGroup getTopThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static void forkSecondaryFinalizer(final Runnable runnable, final String string) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(Finalizer.getTopThreadGroup(), runnable, string);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    public static void runFinalization() {
        GC.runNormalGc();
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = Finalizer.createGlobalContext();
                try {
                    Object object;
                    while ((object = Finalizer.getNextFinalizee(l)) != null) {
                        Finalizer.doFinalize(object);
                    }
                }
                finally {
                    Finalizer.destroyGlobalContext(l);
                }
            }
        }, "Secondary Finalizer");
    }

    private static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = Finalizer.createGlobalContext();
                try {
                    while (true) {
                        Object object;
                        if ((object = Finalizer.getUnfinalizedFinalizee(l)) == null) {
                            GC.runNormalGc();
                            object = Finalizer.getUnfinalizedFinalizee(l);
                        }
                        if (object == null) {
                            break;
                        }
                        Finalizer.doFinalize(object);
                    }
                }
                finally {
                    Finalizer.destroyGlobalContext(l);
                }
            }
        }, "Unsafe Secondary Finalizer");
    }

    private static void startFinalizerThread(final long l) {
        Thread thread = new Thread(Finalizer.getTopThreadGroup(), new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = new Object[Finalizer.getFinalizeeArraySize(l)];
                int n = Finalizer.waitForFinalizees(l, objectArray);
                while (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        Finalizer.doFinalize(objectArray[i]);
                        objectArray[i] = null;
                    }
                    n = Finalizer.waitForFinalizees(l, objectArray);
                }
            }
        }, "Finalizer");
        thread.setPriority(8);
        thread.setDaemon(true);
        thread.start();
    }
}

