/*
 * Decompiled with CFR 0.152.
 */
package jrockit.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import sun.security.action.GetPropertyAction;

class AgentStarter {
    private static final File[] paths;
    private static final WeakHashMap<Class, String> agents;
    private static final HashSet<Class> startedAgents;

    private AgentStarter() {
    }

    private static File findJar(String string) throws FileNotFoundException {
        if (string.toLowerCase().endsWith(".jar")) {
            for (File file : paths) {
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                return file2;
            }
        }
        throw new FileNotFoundException(string);
    }

    private static Class getJarClass(String string) throws ClassNotFoundException, IOException {
        File file = AgentStarter.findJar(string);
        JarFile jarFile = new JarFile(file);
        try {
            String string2 = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURL()});
            return Class.forName(string2, false, uRLClassLoader);
        }
        catch (NullPointerException nullPointerException) {
            throw new ClassNotFoundException(string);
        }
    }

    private static Class loadAgent(String string) throws ClassNotFoundException, IOException {
        try {
            return Class.forName(string, true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return AgentStarter.getJarClass(string);
        }
    }

    private static Class locateAgent(String string, boolean bl) {
        for (Map.Entry<Class, String> entry : agents.entrySet()) {
            Class clazz;
            if (!entry.getValue().equals(string) || (clazz = entry.getKey()) == null) continue;
            return clazz;
        }
        try {
            if (bl) {
                try {
                    return AgentStarter.loadAgent(string);
                }
                catch (IOException iOException) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Could not locate agent " + string);
    }

    private static synchronized void startAgent(String string, String string2) throws Throwable {
        Class clazz = AgentStarter.locateAgent(string, true);
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("start", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getDeclaredMethod("premain", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    clazz.newInstance();
                    return;
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalArgumentException(clazz.getName() + " - could not find start," + " premain or default constructor.");
                }
            }
        }
        method.setAccessible(true);
        try {
            method.invoke(null, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        agents.put(clazz, string);
        startedAgents.add(clazz);
    }

    private static synchronized void stopAgent(String string, String string2) throws Throwable {
        Class clazz = AgentStarter.locateAgent(string, false);
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("stop", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getDeclaredMethod("premain", String.class);
                string2 = "stop=true," + string2;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalArgumentException(clazz.getName() + " - could not find stop or" + " premain.");
            }
        }
        method.setAccessible(true);
        try {
            method.invoke(null, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        startedAgents.remove(clazz);
    }

    static {
        agents = new WeakHashMap();
        startedAgents = new HashSet();
        String string = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(new File(""));
        for (String string3 : string2.split(File.pathSeparator)) {
            File file = new File(string3);
            if (file.isFile()) {
                file = file.getParentFile();
            }
            arrayList.add(file);
        }
        arrayList.add(new File(string, "lib"));
        paths = arrayList.toArray(new File[arrayList.size()]);
    }
}

