/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;
import sun.io.CharToByteUTF8;
import sun.io.ConversionBufferFullException;

public class TrimmedOutputStreamWriter
extends Writer {
    private CharToByteConverter ctb;
    private OutputStream out;
    private static final int defaultByteBufferSize = 8192;
    private int byteBufferSize;
    private byte[] bb;
    private int nextByte = 0;
    private int nBytes = 0;

    private static CharToByteConverter getCTB(String string) throws UnsupportedEncodingException {
        if (string.equalsIgnoreCase("UTF8") || string.equalsIgnoreCase("UTF-8")) {
            return new CharToByteUTF8();
        }
        return CharToByteConverter.getConverter(string);
    }

    public TrimmedOutputStreamWriter(OutputStream outputStream, String string, int n) throws UnsupportedEncodingException {
        this(outputStream, TrimmedOutputStreamWriter.getCTB(string), n);
    }

    public TrimmedOutputStreamWriter(OutputStream outputStream, int n) {
        this(outputStream, CharToByteConverter.getDefault(), n);
    }

    private TrimmedOutputStreamWriter(OutputStream outputStream, CharToByteConverter charToByteConverter, int n) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        this.out = outputStream;
        this.ctb = charToByteConverter;
        this.byteBufferSize = n <= 0 || n > 8192 ? 8192 : n;
        this.bb = new byte[this.byteBufferSize];
        this.nBytes = this.byteBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ctb != null) {
                return this.ctb.getCharacterEncoding();
            }
            return null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            boolean bl = false;
            while (n3 < n4) {
                boolean bl2 = false;
                try {
                    this.nextByte += this.ctb.convertAny(cArray, n3, n4, this.bb, this.nextByte, this.nBytes);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb.nextCharIndex();
                    if (n5 == n3 && bl) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl2 = true;
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte < this.nBytes && !bl2) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
                bl = true;
            }
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                try {
                    this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte == 0) break;
                if (this.nextByte <= 0) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
            this.bb = null;
            this.ctb = null;
        }
    }
}

