/*
 * Decompiled with CFR 0.152.
 */
package jrockit.io;

import java.io.FileDescriptor;
import java.io.IOException;
import jrockit.annotations.Internal;
import jrockit.io.NativeIO;
import jrockit.vm.Threads;

@Internal
public final class FileNativeIO
extends NativeIO {
    private FileNativeIO() {
    }

    private static native int readBytesPinned(FileDescriptor var0, byte[] var1, int var2, int var3) throws IOException;

    private static native void writeBytesPinned(FileDescriptor var0, byte[] var1, int var2, int var3, boolean var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readBytes(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        FileNativeIO.checkBounds(byArray, n, n2);
        if (n2 == 0) {
            return 0;
        }
        try {
            byte[] byArray2 = (byte[])Threads.pinObject(byArray);
            int n4 = n3 = FileNativeIO.readBytesPinned(fileDescriptor, byArray2, n, n2);
            return n4;
        }
        finally {
            Threads.unpinLastObject();
        }
    }

    public static void writeBytes(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2) throws IOException {
        FileNativeIO.writeBytes(fileDescriptor, byArray, n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        FileNativeIO.checkBounds(byArray, n, n2);
        if (n2 == 0) {
            return;
        }
        try {
            byte[] byArray2 = (byte[])Threads.pinObject(byArray);
            FileNativeIO.writeBytesPinned(fileDescriptor, byArray2, n, n2, bl);
        }
        finally {
            Threads.unpinLastObject();
        }
    }
}

