/*
 * Decompiled with CFR 0.152.
 */
package jrockit.ext.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@Deprecated
public class OSInfo {
    private static OSInfo theInstance;
    private final Field socketFdFld;
    private final Field socketImplFld;
    private final Field socketchimplFdFld;
    private final Field fdValue;
    private final Field fdHandle;
    private final Class<?> socketchimplClass;

    private OSInfo() throws ClassNotFoundException, NoSuchFieldException {
        Field f = Socket.class.getDeclaredField("impl");
        f.setAccessible(true);
        this.socketImplFld = f;
        f = SocketImpl.class.getDeclaredField("fd");
        f.setAccessible(true);
        this.socketFdFld = f;
        this.socketchimplClass = Class.forName("sun.nio.ch.SocketChannelImpl");
        f = this.socketchimplClass.getDeclaredField("fd");
        f.setAccessible(true);
        this.socketchimplFdFld = f;
        f = FileDescriptor.class.getDeclaredField("fd");
        f.setAccessible(true);
        this.fdValue = f;
        try {
            f = FileDescriptor.class.getDeclaredField("handle");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException ignore) {
            f = this.fdValue;
        }
        this.fdHandle = f;
    }

    public static synchronized OSInfo getOSInfo() {
        SecurityManager m = System.getSecurityManager();
        if (m != null) {
            m.checkPermission(new AllPermission());
        }
        if (theInstance == null) {
            try {
                theInstance = AccessController.doPrivileged(new PrivilegedExceptionAction<OSInfo>(){

                    @Override
                    public OSInfo run() throws ClassNotFoundException, NoSuchFieldException {
                        return new OSInfo();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return theInstance;
    }

    private long getFileFDHandle(FileDescriptor fd) {
        try {
            return this.fdHandle.getLong(fd);
        }
        catch (IllegalAccessException ex) {
            return -1L;
        }
    }

    private long getFDValue(FileDescriptor fd) {
        try {
            return this.fdValue.getLong(fd);
        }
        catch (IllegalAccessException ex) {
            return -1L;
        }
    }

    public long getOSFileDescriptor(FileInputStream fis) throws IOException {
        return this.getFileFDHandle(fis.getFD());
    }

    public long getOSFileDescriptor(FileOutputStream fos) throws IOException {
        return this.getFileFDHandle(fos.getFD());
    }

    public long getOSFileDescriptor(RandomAccessFile raf) throws IOException {
        return this.getFileFDHandle(raf.getFD());
    }

    public long getOSFileDescriptor(Socket socket) throws IOException, IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("null socket");
        }
        Object impl = null;
        try {
            impl = this.socketImplFld.get(socket);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("could not access Socket.impl field");
        }
        if (impl == null) {
            throw new IllegalArgumentException("socket not created");
        }
        FileDescriptor fd = null;
        try {
            fd = (FileDescriptor)this.socketFdFld.get(impl);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("could not access SocketImpl.fd field");
        }
        if (fd == null) {
            throw new IOException("socket closed");
        }
        return this.getFDValue(fd);
    }

    public long getOSFileDescriptor(SocketChannel socketChannel) throws IOException, IllegalArgumentException {
        if (socketChannel == null) {
            throw new IllegalArgumentException("null socketChannel");
        }
        if (!socketChannel.isConnected()) {
            throw new IOException("SocketChannel not connected");
        }
        if (!this.socketchimplClass.isInstance(socketChannel)) {
            throw new IllegalArgumentException("invalid SocketChannel subclass");
        }
        FileDescriptor fd = null;
        try {
            fd = (FileDescriptor)this.socketchimplFdFld.get(socketChannel);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("could not access SocketChannelImpl.fd field");
        }
        if (fd == null) {
            throw new IOException("socket closed");
        }
        return this.getFDValue(fd);
    }

    public int getBytesAvailable(SocketChannel channel) throws IOException {
        int res = this.getBytesAvailable0(this.getOSFileDescriptor(channel));
        if (res == -1) {
            throw new IOException();
        }
        return res;
    }

    private native int getBytesAvailable0(long var1) throws IOException;

    static {
        System.loadLibrary("orii");
        theInstance = null;
    }
}

