/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;
import java.util.zip.ZStreamRef;
import jrockit.vm.Memory;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;

public class Inflater {
    private final ZStreamRef zsRef;
    private byte[] buf = emptyBuf;
    private int off;
    private int len;
    private boolean finished;
    private boolean needDict;
    private static byte[] emptyBuf = new byte[0];

    public Inflater(boolean bl) {
        this.zsRef = new ZStreamRef(Inflater.init(bl));
    }

    public Inflater() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            Inflater.setDictionary(this.zsRef.address(), byArray, n, n2);
            this.needDict = false;
        }
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemaining() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsInput() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.len <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsDictionary() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.needDict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return this.inflateBytes(this.zsRef.address(), byArray, n, n2);
        }
    }

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return Inflater.getAdler(this.zsRef.address());
        }
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return Inflater.getBytesRead(this.zsRef.address());
        }
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return Inflater.getBytesWritten(this.zsRef.address());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            Inflater.reset(this.zsRef.address());
            this.buf = emptyBuf;
            this.finished = false;
            this.needDict = false;
            this.len = 0;
            this.off = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            int n = this.zsRef.address();
            this.zsRef.clear();
            if (n != 0) {
                Inflater.end(n);
                this.buf = null;
            }
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0) {
            throw new NullPointerException("Inflater has been closed");
        }
    }

    private static native int init(boolean var0);

    private static native void setDictionary(int var0, byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inflateBytes(int n, byte[] byArray, int n2, int n3) throws DataFormatException {
        this.ensureOpen();
        int n4 = Threads.getCurrentVMThread();
        try {
            byte[] byArray2 = (byte[])Threads.pinObject(n4, byArray);
            byte[] byArray3 = (byte[])Threads.pinObject(n4, this.buf);
            int n5 = Memory.getArrayData(byArray2, n2);
            int n6 = Memory.getArrayData(byArray3, this.off);
            int n7 = Inflater.inflateFast(n, n6, this.len, n5, n3);
            int n8 = Reflect.IZStream.getAvailIn(n);
            int n9 = Reflect.IZStream.getAvailOut(n);
            switch (n7) {
                case 1: {
                    this.finished = true;
                }
                case 0: {
                    this.off = this.off + this.len - n8;
                    this.len = n8;
                    n7 = n3 - n9;
                    return n7;
                }
                case 2: {
                    this.needDict = true;
                    this.off = this.off + this.len - n8;
                    this.len = n8;
                }
                case -5: 
                case -4: {
                    n7 = 0;
                    return n7;
                }
                default: {
                    throw new InternalError("Z inflate should have provided exception!");
                }
            }
        }
        finally {
            Threads.unpinLastObject(n4);
            Threads.unpinLastObject(n4);
        }
    }

    private static native int inflateFast(int var0, int var1, int var2, int var3, int var4) throws DataFormatException;

    private static native int getAdler(int var0);

    private static native long getBytesRead(int var0);

    private static native long getBytesWritten(int var0);

    private static native void reset(int var0);

    private static native void end(int var0);
}

