/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class ShortBuffer
extends Buffer
implements Comparable<ShortBuffer> {
    final short[] hb;
    final int offset;
    boolean isReadOnly;

    ShortBuffer(int n, int n2, int n3, int n4, short[] sArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = sArray;
        this.offset = n5;
    }

    ShortBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static ShortBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return ShortBuffer.wrap(new short[n], 0, n);
    }

    public static ShortBuffer wrap(short[] sArray, int n, int n2) {
        try {
            return new HeapShortBuffer(sArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public ShortBuffer get(short[] sArray, int n, int n2) {
        ShortBuffer.checkBounds(n, n2, sArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            sArray[i] = this.get();
        }
        return this;
    }

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = shortBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(shortBuffer.get());
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        ShortBuffer.checkBounds(n, n2, sArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(sArray[i]);
        }
        return this;
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final short[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract ShortBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer shortBuffer = (ShortBuffer)object;
        if (this.remaining() != shortBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = shortBuffer.limit() - 1;
        while (n2 >= n) {
            short s;
            short s2 = this.get(n2);
            if (s2 != (s = shortBuffer.get(n3)) && (s2 == s2 || s == s)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    @Override
    public int compareTo(ShortBuffer shortBuffer) {
        int n = this.position() + Math.min(this.remaining(), shortBuffer.remaining());
        int n2 = this.position();
        int n3 = shortBuffer.position();
        while (n2 < n) {
            short s;
            short s2 = this.get(n2);
            if (s2 != (s = shortBuffer.get(n3)) && (s2 == s2 || s == s)) {
                if (s2 < s) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - shortBuffer.remaining();
    }

    public abstract ByteOrder order();
}

