/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;

class HeapLongBuffer
extends LongBuffer {
    HeapLongBuffer(int n, int n2) {
        super(-1, 0, n2, n, new long[n], 0);
    }

    HeapLongBuffer(long[] lArray, int n, int n2) {
        super(-1, n, n + n2, lArray.length, lArray, 0);
    }

    protected HeapLongBuffer(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, lArray, n5);
    }

    @Override
    public LongBuffer slice() {
        return new HeapLongBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public LongBuffer duplicate() {
        return new HeapLongBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public long get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public long get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public LongBuffer get(long[] lArray, int n, int n2) {
        HeapLongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), lArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public LongBuffer put(long l) {
        this.hb[this.ix((int)this.nextPutIndex())] = l;
        return this;
    }

    @Override
    public LongBuffer put(int n, long l) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = l;
        return this;
    }

    @Override
    public LongBuffer put(long[] lArray, int n, int n2) {
        HeapLongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(lArray, n, this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof HeapLongBuffer) {
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapLongBuffer heapLongBuffer = (HeapLongBuffer)longBuffer;
            int n = heapLongBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapLongBuffer.hb, heapLongBuffer.ix(heapLongBuffer.position()), this.hb, this.ix(this.position()), n);
            heapLongBuffer.position(heapLongBuffer.position() + n);
            this.position(this.position() + n);
        } else if (longBuffer.isDirect()) {
            int n = longBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            longBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

