/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapDoubleBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class DoubleBuffer
extends Buffer
implements Comparable<DoubleBuffer> {
    final double[] hb;
    final int offset;
    boolean isReadOnly;

    DoubleBuffer(int n, int n2, int n3, int n4, double[] dArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = dArray;
        this.offset = n5;
    }

    DoubleBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static DoubleBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return DoubleBuffer.wrap(new double[n], 0, n);
    }

    public static DoubleBuffer wrap(double[] dArray, int n, int n2) {
        try {
            return new HeapDoubleBuffer(dArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static DoubleBuffer wrap(double[] dArray) {
        return DoubleBuffer.wrap(dArray, 0, dArray.length);
    }

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public DoubleBuffer get(double[] dArray, int n, int n2) {
        DoubleBuffer.checkBounds(n, n2, dArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            dArray[i] = this.get();
        }
        return this;
    }

    public DoubleBuffer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = doubleBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(doubleBuffer.get());
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n, int n2) {
        DoubleBuffer.checkBounds(n, n2, dArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(dArray[i]);
        }
        return this;
    }

    public final DoubleBuffer put(double[] dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final double[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract DoubleBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        if (this.remaining() != doubleBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = doubleBuffer.limit() - 1;
        while (n2 >= n) {
            double d;
            double d2 = this.get(n2);
            if (d2 != (d = doubleBuffer.get(n3)) && (d2 == d2 || d == d)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    @Override
    public int compareTo(DoubleBuffer doubleBuffer) {
        int n = this.position() + Math.min(this.remaining(), doubleBuffer.remaining());
        int n2 = this.position();
        int n3 = doubleBuffer.position();
        while (n2 < n) {
            double d;
            double d2 = this.get(n2);
            if (d2 != (d = doubleBuffer.get(n3)) && (d2 == d2 || d == d)) {
                if (d2 < d) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - doubleBuffer.remaining();
    }

    public abstract ByteOrder order();
}

