/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRS;
import java.nio.LongBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferS
extends LongBuffer
implements DirectBuffer {
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = (int)directBuffer.address() + n5;
        this.viewedBuffer = directBuffer;
    }

    @Override
    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectLongBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public LongBuffer duplicate() {
        return new DirectLongBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    private int ix(int n) {
        return this.address + (n << 3);
    }

    @Override
    public long get() {
        return Memory.bswap(Memory.getLong(this.ix(this.nextGetIndex())));
    }

    @Override
    public long get(int n) {
        return Memory.bswap(Memory.getLong(this.ix(this.checkIndex(n))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongBuffer get(long[] lArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = lArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i + n] = Bits.getLongB(n9 + (i << 3));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        lArray[i + n] = Bits.getLongL(n9 + (i << 3));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            long[] lArray2 = (long[])Threads.pinObject(n10, lArray);
            try {
                int n11 = Memory.getArrayData(lArray2, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectLongBufferS directLongBufferS = this;
                return directLongBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(lArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongBuffer put(long[] lArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = lArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferOverflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putLongB(n9 + (i << 3), lArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putLongL(n9 + (i << 3), lArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            long[] lArray2 = (long[])Threads.pinObject(n10, lArray);
            try {
                int n11 = Memory.getArrayData(lArray2, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectLongBufferS directLongBufferS = this;
                return directLongBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(lArray, n, n2);
    }

    @Override
    public LongBuffer put(long l) {
        Memory.setLong(this.ix(this.nextPutIndex()), Memory.bswap(l));
        return this;
    }

    @Override
    public LongBuffer put(int n, long l) {
        Memory.setLong(this.ix(this.checkIndex(n)), Memory.bswap(l));
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferS) {
            int n;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferS directLongBufferS = (DirectLongBufferS)longBuffer;
            int n2 = directLongBufferS.position();
            int n3 = directLongBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directLongBufferS.ix(n2), n4 << 3);
            directLongBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!longBuffer.isDirect()) {
            int n = longBuffer.position();
            int n8 = longBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(longBuffer.hb, longBuffer.offset + n, n9);
            longBuffer.position(n + n9);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

