/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectIntBufferRS;
import java.nio.IntBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferS
extends IntBuffer
implements DirectBuffer {
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectIntBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = (int)directBuffer.address() + n5;
        this.viewedBuffer = directBuffer;
    }

    @Override
    public IntBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        assert (n4 >= 0);
        return new DirectIntBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public IntBuffer duplicate() {
        return new DirectIntBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    private int ix(int n) {
        return this.address + (n << 2);
    }

    @Override
    public int get() {
        return Memory.bswap(Memory.getInt(this.ix(this.nextGetIndex())));
    }

    @Override
    public int get(int n) {
        return Memory.bswap(Memory.getInt(this.ix(this.checkIndex(n))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntBuffer get(int[] nArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = nArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectIntBufferS.checkBounds(n, n2, nArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        nArray[i + n] = Bits.getIntB(n9 + (i << 2));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        nArray[i + n] = Bits.getIntL(n9 + (i << 2));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            int[] nArray2 = (int[])Threads.pinObject(n10, nArray);
            try {
                int n11 = Memory.getArrayData(nArray2, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectIntBufferS directIntBufferS = this;
                return directIntBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(nArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntBuffer put(int[] nArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = nArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectIntBufferS.checkBounds(n, n2, nArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferOverflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putIntB(n9 + (i << 2), nArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putIntL(n9 + (i << 2), nArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            int[] nArray2 = (int[])Threads.pinObject(n10, nArray);
            try {
                int n11 = Memory.getArrayData(nArray2, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectIntBufferS directIntBufferS = this;
                return directIntBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(nArray, n, n2);
    }

    @Override
    public IntBuffer put(int n) {
        Memory.setInt(this.ix(this.nextPutIndex()), Memory.bswap(n));
        return this;
    }

    @Override
    public IntBuffer put(int n, int n2) {
        Memory.setInt(this.ix(this.checkIndex(n)), Memory.bswap(n2));
        return this;
    }

    @Override
    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferS) {
            int n;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferS directIntBufferS = (DirectIntBufferS)intBuffer;
            int n2 = directIntBufferS.position();
            int n3 = directIntBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directIntBufferS.ix(n2), n4 << 2);
            directIntBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!intBuffer.isDirect()) {
            int n = intBuffer.position();
            int n8 = intBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(intBuffer.hb, intBuffer.offset + n, n9);
            intBuffer.position(n + n9);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    @Override
    public IntBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

