/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRS;
import java.nio.FloatBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferS
extends FloatBuffer
implements DirectBuffer {
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = (int)directBuffer.address() + n5;
        this.viewedBuffer = directBuffer;
    }

    @Override
    public FloatBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        assert (n4 >= 0);
        return new DirectFloatBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public FloatBuffer duplicate() {
        return new DirectFloatBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    private int ix(int n) {
        return this.address + (n << 2);
    }

    @Override
    public float get() {
        return Float.intBitsToFloat(Memory.bswap(Memory.getInt(this.ix(this.nextGetIndex()))));
    }

    @Override
    public float get(int n) {
        return Float.intBitsToFloat(Memory.bswap(Memory.getInt(this.ix(this.checkIndex(n)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatBuffer get(float[] fArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = fArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectFloatBufferS.checkBounds(n, n2, fArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i + n] = Bits.getFloatB(n9 + (i << 2));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i + n] = Bits.getFloatL(n9 + (i << 2));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            float[] fArray2 = (float[])Threads.pinObject(n10, fArray);
            try {
                int n11 = Memory.getArrayData(fArray2, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectFloatBufferS directFloatBufferS = this;
                return directFloatBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(fArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatBuffer put(float[] fArray, int n, int n2) {
        int n3 = n2 << 2;
        int n4 = fArray.length << 2;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectFloatBufferS.checkBounds(n, n2, fArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferOverflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putFloatB(n9 + (i << 2), fArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putFloatL(n9 + (i << 2), fArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            float[] fArray2 = (float[])Threads.pinObject(n10, fArray);
            try {
                int n11 = Memory.getArrayData(fArray2, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectFloatBufferS directFloatBufferS = this;
                return directFloatBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(fArray, n, n2);
    }

    @Override
    public FloatBuffer put(float f) {
        Memory.setInt(this.ix(this.nextPutIndex()), Memory.bswap(Float.floatToIntBits(f)));
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        Memory.setInt(this.ix(this.checkIndex(n)), Memory.bswap(Float.floatToIntBits(f)));
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof DirectFloatBufferS) {
            int n;
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferS directFloatBufferS = (DirectFloatBufferS)floatBuffer;
            int n2 = directFloatBufferS.position();
            int n3 = directFloatBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directFloatBufferS.ix(n2), n4 << 2);
            directFloatBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!floatBuffer.isDirect()) {
            int n = floatBuffer.position();
            int n8 = floatBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(floatBuffer.hb, floatBuffer.offset + n, n9);
            floatBuffer.position(n + n9);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

