/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectDoubleBufferRS;
import java.nio.DoubleBuffer;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferS
extends DoubleBuffer
implements DirectBuffer {
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectDoubleBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = (int)directBuffer.address() + n5;
        this.viewedBuffer = directBuffer;
    }

    @Override
    public DoubleBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectDoubleBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new DirectDoubleBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    private int ix(int n) {
        return this.address + (n << 3);
    }

    @Override
    public double get() {
        return Double.longBitsToDouble(Memory.bswap(Memory.getLong(this.ix(this.nextGetIndex()))));
    }

    @Override
    public double get(int n) {
        return Double.longBitsToDouble(Memory.bswap(Memory.getLong(this.ix(this.checkIndex(n)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleBuffer get(double[] dArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = dArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectDoubleBufferS.checkBounds(n, n2, dArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i + n] = Bits.getDoubleB(n9 + (i << 3));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i + n] = Bits.getDoubleL(n9 + (i << 3));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            double[] dArray2 = (double[])Threads.pinObject(n10, dArray);
            try {
                int n11 = Memory.getArrayData(dArray2, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectDoubleBufferS directDoubleBufferS = this;
                return directDoubleBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(dArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleBuffer put(double[] dArray, int n, int n2) {
        int n3 = n2 << 3;
        int n4 = dArray.length << 3;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectDoubleBufferS.checkBounds(n, n2, dArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferOverflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putDoubleB(n9 + (i << 3), dArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putDoubleL(n9 + (i << 3), dArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            double[] dArray2 = (double[])Threads.pinObject(n10, dArray);
            try {
                int n11 = Memory.getArrayData(dArray2, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectDoubleBufferS directDoubleBufferS = this;
                return directDoubleBufferS;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(dArray, n, n2);
    }

    @Override
    public DoubleBuffer put(double d) {
        Memory.setLong(this.ix(this.nextPutIndex()), Memory.bswap(Double.doubleToLongBits(d)));
        return this;
    }

    @Override
    public DoubleBuffer put(int n, double d) {
        Memory.setLong(this.ix(this.checkIndex(n)), Memory.bswap(Double.doubleToLongBits(d)));
        return this;
    }

    @Override
    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof DirectDoubleBufferS) {
            int n;
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectDoubleBufferS directDoubleBufferS = (DirectDoubleBufferS)doubleBuffer;
            int n2 = directDoubleBufferS.position();
            int n3 = directDoubleBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directDoubleBufferS.ix(n2), n4 << 3);
            directDoubleBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!doubleBuffer.isDirect()) {
            int n = doubleBuffer.position();
            int n8 = doubleBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(doubleBuffer.hb, doubleBuffer.offset + n, n9);
            doubleBuffer.position(n + n9);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

