/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferRU;
import jrockit.vm.Memory;
import jrockit.vm.Threads;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferU
extends CharBuffer
implements DirectBuffer {
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectCharBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = (int)directBuffer.address() + n5;
        this.viewedBuffer = directBuffer;
    }

    @Override
    public CharBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 1;
        assert (n4 >= 0);
        return new DirectCharBufferU(this, -1, 0, n3, n3, n4);
    }

    @Override
    public CharBuffer duplicate() {
        return new DirectCharBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    private int ix(int n) {
        return this.address + (n << 1);
    }

    @Override
    public char get() {
        return Memory.getChar(this.ix(this.nextGetIndex()));
    }

    @Override
    public char get(int n) {
        return Memory.getChar(this.ix(this.checkIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer get(char[] cArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = cArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectCharBufferU.checkBounds(n, n2, cArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferUnderflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        cArray[i + n] = Bits.getCharB(n9 + (i << 1));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        cArray[i + n] = Bits.getCharL(n9 + (i << 1));
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            char[] cArray2 = (char[])Threads.pinObject(n10, cArray);
            try {
                int n11 = Memory.getArrayData(cArray2, n);
                Memory.copyMemory(n11, this.ix(this.nextGetIndex(n2)), n3);
                DirectCharBufferU directCharBufferU = this;
                return directCharBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.get(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer put(char[] cArray, int n, int n2) {
        int n3 = n2 << 1;
        int n4 = cArray.length << 1;
        ByteOrder byteOrder = this.order();
        if (byteOrder != Bits.byteOrder() || n3 > 128) {
            int n5;
            DirectCharBufferU.checkBounds(n, n2, cArray.length);
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n5 = n6 <= n7 ? n7 - n6 : 0;
            if (n2 > n5) {
                throw new BufferOverflowException();
            }
            if (byteOrder != Bits.byteOrder()) {
                int n9 = this.ix(n6);
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putCharB(n9 + (i << 1), cArray[i + n]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Bits.putCharL(n9 + (i << 1), cArray[i + n]);
                    }
                }
                this.nextGetIndex(n2);
                return this;
            }
            int n10 = Threads.getCurrentVMThread();
            char[] cArray2 = (char[])Threads.pinObject(n10, cArray);
            try {
                int n11 = Memory.getArrayData(cArray2, n);
                Memory.copyMemory(this.ix(this.nextGetIndex(n2)), n11, n3);
                DirectCharBufferU directCharBufferU = this;
                return directCharBufferU;
            }
            finally {
                Threads.unpinLastObject(n10);
            }
        }
        return super.put(cArray, n, n2);
    }

    @Override
    public CharBuffer put(char c) {
        Memory.setChar(this.ix(this.nextPutIndex()), c);
        return this;
    }

    @Override
    public CharBuffer put(int n, char c) {
        Memory.setChar(this.ix(this.checkIndex(n)), c);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof DirectCharBufferU) {
            int n;
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferU directCharBufferU = (DirectCharBufferU)charBuffer;
            int n2 = directCharBufferU.position();
            int n3 = directCharBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            Memory.copyMemory(this.ix(n5), directCharBufferU.ix(n2), n4 << 1);
            directCharBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!charBuffer.isDirect()) {
            int n = charBuffer.position();
            int n8 = charBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(charBuffer.hb, charBuffer.offset + n, n9);
            charBuffer.position(n + n9);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        Memory.copyMemory(this.ix(0), this.ix(n), n3 << 1);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString(int n, int n2) {
        if (n2 > this.limit() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int n3 = n2 - n;
            char[] cArray = new char[n3];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharBuffer charBuffer2 = this.duplicate();
            charBuffer2.position(n);
            charBuffer2.limit(n2);
            charBuffer.put(charBuffer2);
            return new String(cArray);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        int n3 = this.length();
        int n4 = this.position();
        assert (n4 <= n3);
        int n5 = n4 = n4 <= n3 ? n4 : n3;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new DirectCharBufferU(this, -1, n4 + n, n4 + n2, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

