/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import jrockit.memory.ClearedPhantomReference;
import sun.misc.Cleaner;

public abstract class Reference<T> {
    private T referent;
    ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock = new Lock();
    private static Reference pending = null;
    private Reference activatedQueueNext;
    private int ownerThread;
    private boolean isActivated;

    private static native Reference waitForActivatedQueue(long var0);

    static void startReferenceHandler(long l) {
        ReferenceQueue.NULL = null;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler", l);
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue == ReferenceQueue.ENQUEUED;
        }
    }

    public boolean enqueue() {
        ReferenceQueue<T> referenceQueue = this.queue;
        if (referenceQueue == null) {
            return false;
        }
        return referenceQueue.enqueue(this);
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        this.referent = t;
        this.queue = referenceQueue;
    }

    private static class ReferenceHandler
    extends Thread {
        private long context;

        ReferenceHandler(ThreadGroup threadGroup, String string, long l) {
            super(threadGroup, string);
            this.context = l;
        }

        @Override
        public void run() {
            block0: while (true) {
                Reference reference = null;
                Reference reference2 = Reference.waitForActivatedQueue(this.context);
                if (reference2 == null) {
                    return;
                }
                while (true) {
                    if (reference2 == null) continue block0;
                    reference = reference2;
                    reference2 = reference.activatedQueueNext;
                    reference.activatedQueueNext = null;
                    if (reference instanceof ClearedPhantomReference) {
                        ((ClearedPhantomReference)reference).clean();
                        continue;
                    }
                    if (reference instanceof Cleaner) {
                        ((Cleaner)reference).clean();
                        continue;
                    }
                    ReferenceQueue referenceQueue = reference.queue;
                    if (referenceQueue == null) continue;
                    referenceQueue.enqueue(reference);
                }
                break;
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

