/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;
import java.util.Arrays;
import jrockit.annotations.NoInline;

class StringValue {
    private static boolean stringCacheEnabled;
    private static final StringCache cache;

    private StringValue() {
    }

    static char[] from(char[] cArray) {
        if (stringCacheEnabled) {
            char[] cArray2 = StringValue.cache.get(cArray);
            return cArray2 != null ? cArray2 : Arrays.copyOf(cArray, cArray.length);
        }
        return Arrays.copyOf(cArray, cArray.length);
    }

    static {
        cache = new StringCache();
    }

    private static class StringCache {
        private static final int ARRAY_MIN_SIZE = 64;
        private static final int MAX_PROFILE_SIZE = 32;
        private static final int MAX_CACHE_SIZE = 8;
        private static final int STRING_CACHE_CREATE_THRESHOLD = 1000000;
        private static final float STRING_FREQ_THRESHOLD = 0.125f;
        final ArrayList<StringProfile> profile = new ArrayList();
        private static int allocs;
        char[][] cache;
        private boolean profiling = true;
        private boolean cacheInitialized;

        private StringCache() {
        }

        private StringProfile removeColdestProfile() {
            int n = 0;
            int n2 = 0;
            int n3 = 0x40000000;
            for (StringProfile stringProfile : this.profile) {
                if (stringProfile.refs < n3) {
                    n3 = stringProfile.refs;
                    n2 = n;
                }
                ++n;
            }
            return this.profile.remove(n2);
        }

        private StringProfile removeHottestProfile() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (StringProfile stringProfile : this.profile) {
                if (stringProfile.refs > n3) {
                    n3 = stringProfile.refs;
                    n2 = n;
                }
                ++n;
            }
            if (this.profile.size() == 0) {
                return null;
            }
            return this.profile.remove(n2);
        }

        private StringProfile getFromProfile(char[] cArray) {
            for (StringProfile stringProfile : this.profile) {
                if (!Arrays.equals(stringProfile.value, cArray)) continue;
                ++stringProfile.refs;
                return stringProfile;
            }
            return null;
        }

        private void putToProfile(char[] cArray) {
            if (this.profile.size() == 32) {
                this.removeColdestProfile();
            }
            char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
            StringProfile stringProfile = new StringProfile(cArray2);
            this.profile.add(stringProfile);
        }

        private void buildCache() {
            int n;
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            if (this.profile.size() > 0) {
                StringProfile stringProfile;
                while (arrayList.size() <= 8 && (stringProfile = this.removeHottestProfile()) != null && stringProfile.refs != 0 && !((float)stringProfile.refs / (float)allocs < 0.125f)) {
                    arrayList.add(stringProfile.value);
                }
                this.profile.clear();
            }
            if ((n = arrayList.size()) > 0) {
                this.cache = new char[n][];
                int n2 = 0;
                for (char[] cArray : arrayList) {
                    this.cache[n2++] = cArray;
                }
                this.cacheInitialized = true;
            }
            this.profiling = false;
        }

        private char[] getFromCache(char[] cArray) {
            if (this.cacheInitialized) {
                for (char[] cArray2 : this.cache) {
                    if (!Arrays.equals(cArray2, cArray)) continue;
                    return cArray2;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NoInline
        private void profile(char[] cArray) {
            if (cArray.length < 64) {
                return;
            }
            ArrayList<StringProfile> arrayList = this.profile;
            synchronized (arrayList) {
                if (!this.profiling) {
                    return;
                }
                StringProfile stringProfile = this.getFromProfile(cArray);
                if (stringProfile == null) {
                    this.putToProfile(cArray);
                }
                if (++allocs == 1000000) {
                    this.buildCache();
                }
            }
        }

        private char[] get(char[] cArray) {
            if (cArray.length < 64) {
                return null;
            }
            if (!this.profiling) {
                return this.getFromCache(cArray);
            }
            this.profile(cArray);
            return null;
        }
    }

    private static class StringProfile {
        int refs;
        char[] value;

        private StringProfile(char[] cArray) {
            this.value = cArray;
            this.refs = 1;
        }
    }
}

