/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jrockit.io.FileNativeIO;
import sun.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean rw;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(string != null ? new File(string) : null, string2);
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        String string2 = file != null ? file.getPath() : null;
        int n = -1;
        if (string.equals("r")) {
            n = 1;
        } else if (string.startsWith("rw")) {
            n = 2;
            this.rw = true;
            if (string.length() > 2) {
                n = string.equals("rws") ? (n |= 4) : (string.equals("rwd") ? (n |= 8) : -1);
            }
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + string + "\" must be one of " + "\"r\", \"rw\", \"rws\"," + " or \"rwd\"");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string2);
            if (this.rw) {
                securityManager.checkWrite(string2);
            }
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.open(string2, n);
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, true, this.rw, this);
            }
            return this.channel;
        }
    }

    private native void open(String var1, int var2) throws FileNotFoundException;

    public native int read() throws IOException;

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        return FileNativeIO.readBytes(this.fd, byArray, n, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.getFilePointer();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.length())) {
            l3 = l;
        }
        this.seek(l3);
        return (int)(l3 - l2);
    }

    public native void write(int var1) throws IOException;

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        FileNativeIO.writeBytes(this.fd, byArray, n, n2, false);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public native long getFilePointer() throws IOException;

    public native void seek(long var1) throws IOException;

    public native long length() throws IOException;

    public native void setLength(long var1) throws IOException;

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        this.close0();
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        this.writeBytes(byArray, 0, n);
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n3++] = (byte)(cArray[i] >>> 8);
            byArray[n3++] = (byte)(cArray[i] >>> 0);
        }
        this.writeBytes(byArray, 0, n2);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    static {
        RandomAccessFile.initIDs();
    }
}

