/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import jrockit.io.FileNativeIO;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean append = false;

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.append = bl;
        if (bl) {
            this.openAppend(string);
        } else {
            this.open(string);
        }
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws FileNotFoundException;

    private native void openAppend(String var1) throws FileNotFoundException;

    public native void write(int var1) throws IOException;

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        FileNativeIO.writeBytes(this.fd, byArray, n, n2, this.append);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        this.close0();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, false, true, this, this.append);
            }
            return this.channel;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void finalize() throws IOException {
        if (this.fd == null) return;
        if (this.fd != FileDescriptor.out) {
            if (this.fd != FileDescriptor.err) {
                this.close();
                return;
            }
        }
        this.flush();
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

