/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlightRecordingClient
implements FlightRecordingMBean {
    protected final FlightRecorderClient client;
    protected final FlightRecordingMBean mbean;
    protected final ObjectName objectName;

    FlightRecordingClient(FlightRecorderClient client, FlightRecordingMBean mbean, ObjectName objectName) {
        this.client = client;
        this.objectName = objectName;
        this.mbean = mbean;
    }

    protected FlightRecordingClient(FlightRecordingClient other) {
        this(other.client, other.mbean, other.objectName);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public boolean isDestinationCompressed() {
        return this.mbean.isDestinationCompressed();
    }

    @Override
    public void setDestinationCompressed(boolean compress) {
        this.mbean.setDestinationCompressed(compress);
    }

    @Override
    public void copyTo(String path, boolean compress) throws IllegalStateException, IOException {
        this.mbean.copyTo(path, compress);
    }

    @Override
    public void close() {
        this.mbean.close();
    }

    @Override
    public void closeStream(long id) throws IOException, IllegalArgumentException {
        this.mbean.closeStream(id);
    }

    @Override
    public String getDestination() {
        return this.mbean.getDestination();
    }

    @Override
    public long getDuration() {
        return this.mbean.getDuration();
    }

    @Override
    public void addEventDefaults(List<CompositeData> defaults) throws OpenDataException {
        this.mbean.addEventDefaults(defaults);
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.mbean.getEventDefaults();
    }

    @Override
    public void setEventDefaults(List<CompositeData> defaults) throws OpenDataException {
        this.mbean.setEventDefaults(defaults);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        return this.mbean.getEventSettings();
    }

    @Override
    public long getId() {
        return this.mbean.getId();
    }

    @Override
    public long getMaxAge() {
        return this.mbean.getMaxAge();
    }

    @Override
    public long getMaxSize() {
        return this.mbean.getMaxSize();
    }

    @Override
    public String getName() {
        return this.mbean.getName();
    }

    @Override
    public long getDataSize() {
        return this.mbean.getDataSize();
    }

    @Override
    public CompositeData getOptions() throws OpenDataException {
        return this.mbean.getOptions();
    }

    @Override
    public long getPeriod(int id) throws NoSuchEventException {
        return this.mbean.getPeriod(id);
    }

    @Override
    public Date getStartTime() {
        return this.mbean.getStartTime();
    }

    @Override
    public long getThreshold(int id) throws NoSuchEventException {
        return this.mbean.getThreshold(id);
    }

    @Override
    public boolean isEventEnabled(int id) throws NoSuchEventException {
        return this.mbean.isEventEnabled(id);
    }

    @Override
    public boolean isRunning() {
        return this.mbean.isRunning();
    }

    @Override
    public boolean isStackTraceEnabled(int id) throws NoSuchEventException {
        return this.mbean.isStackTraceEnabled(id);
    }

    @Override
    public boolean isStarted() {
        return this.mbean.isStarted();
    }

    @Override
    public boolean isStopped() {
        return this.mbean.isStopped();
    }

    @Override
    public long openStream() throws IOException {
        return this.mbean.openStream();
    }

    @Override
    public long openStream(Date start, Date end) throws IOException {
        return this.mbean.openStream(start, end);
    }

    @Override
    public ObjectName cloneRecording(String newName, boolean stop) throws IOException {
        return this.mbean.cloneRecording(newName, stop);
    }

    public FlightRecordingClient cloneRecordingObject(String newName, boolean stop) throws IOException {
        try {
            return this.client.cloneRecordingObject(this.objectName, newName, stop);
        }
        catch (NoSuchRecordingException e) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(String path) throws IllegalStateException, IOException {
        this.mbean.copyTo(path);
    }

    @Override
    public byte[] readStream(long id) throws IOException, IllegalArgumentException {
        return this.mbean.readStream(id);
    }

    @Override
    public void setDestination(String path) throws IOException {
        this.mbean.setDestination(path);
    }

    @Override
    public void setDuration(long millis) {
        this.mbean.setDuration(millis);
    }

    @Override
    public void setEventEnabled(int id, boolean on) throws NoSuchEventException {
        this.mbean.setEventEnabled(id, on);
    }

    @Override
    public void setEventSettings(List<CompositeData> d) throws OpenDataException {
        this.mbean.setEventSettings(d);
    }

    @Override
    public void setMaxAge(long millis) {
        this.mbean.setMaxAge(millis);
    }

    @Override
    public void setMaxSize(long bytes) {
        this.mbean.setMaxSize(bytes);
    }

    @Override
    public void setOptions(CompositeData d) throws OpenDataException {
        this.mbean.setOptions(d);
    }

    @Override
    public void setPeriod(int id, long period) throws NoSuchEventException {
        this.mbean.setPeriod(id, period);
    }

    @Override
    public void setStackTraceEnabled(int id, boolean on) throws NoSuchEventException {
        this.mbean.setStackTraceEnabled(id, on);
    }

    @Override
    public void setStartTime(Date d) {
        this.mbean.setStartTime(d);
    }

    @Override
    public void setThreshold(int id, long nanos) throws NoSuchEventException {
        this.mbean.setThreshold(id, nanos);
    }

    @Override
    public void start() {
        this.mbean.start();
    }

    @Override
    public void stop() throws IOException {
        this.mbean.stop();
    }

    public InputStream openStreamObject() throws IOException {
        final long id = this.openStream();
        return new InputStream(){
            private byte[] bytes;
            private int pos;
            private int count;

            public void close() throws IOException {
                super.close();
                FlightRecordingClient.this.closeStream(id);
            }

            private boolean fill() throws IOException {
                if (this.pos >= this.count) {
                    this.bytes = FlightRecordingClient.this.readStream(id);
                    if (this.bytes == null) {
                        return false;
                    }
                    this.pos = 0;
                    this.count = this.bytes.length;
                }
                return true;
            }

            public int read() throws IOException {
                if (!this.fill()) {
                    return -1;
                }
                return this.bytes[this.pos++] & 0xFF;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (!this.fill()) {
                    return -1;
                }
                int n = Math.min(this.count - this.pos, len);
                System.arraycopy(this.bytes, this.pos, b, off, n);
                this.pos += n;
                return n;
            }
        };
    }

    public InputStream openUncompressedStreamObject() throws IOException {
        return new GZIPInputStream(this.openStreamObject());
    }

    public String toString() {
        long maxsize;
        long maxage;
        long dur;
        Date d;
        Date startTime;
        StringBuilder buf = new StringBuilder();
        buf.append(this.objectName);
        String dest = this.getDestination();
        if (dest != null) {
            buf.append(", destination=").append(dest);
        }
        if ((startTime = this.getStartTime()) != null) {
            buf.append(", start=").append(startTime);
        }
        if ((d = this.getDataStartTime()) != null) {
            buf.append(", dataStartTime=").append(d);
        }
        if ((d = this.getDataEndTime()) != null) {
            buf.append(", dataEndTime=").append(d);
        }
        if ((dur = this.getDuration()) != 0L) {
            buf.append(", duration=").append(dur);
        }
        if ((maxage = this.getMaxAge()) != 0L) {
            buf.append(", maxAge=").append(maxage);
        }
        if ((maxsize = this.getMaxSize()) != 0L) {
            buf.append(", maxSize=").append(maxsize);
        }
        return buf.toString();
    }

    @Override
    public boolean isToDisk() {
        return this.mbean.isToDisk();
    }

    @Override
    public void setToDisk(boolean b) {
        this.mbean.setToDisk(b);
    }

    @Override
    public Date getDataEndTime() {
        return this.mbean.getDataEndTime();
    }

    @Override
    public Date getDataStartTime() {
        return this.mbean.getDataStartTime();
    }
}

