/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.JFR;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlightRecorderClient
implements FlightRecorderMBean {
    private final FlightRecorderMBean remote;
    private final MBeanServerConnection server;
    private static final ObjectName flightRecorderName;

    public FlightRecorderClient() throws InstanceNotFoundException, NullPointerException, IOException {
        JFR jfr = AccessController.doPrivileged(new PrivilegedAction<JFR>(){

            @Override
            public JFR run() {
                return JFR.get();
            }
        });
        this.remote = jfr.getMBean();
        this.server = null;
    }

    public FlightRecorderClient(MBeanServerConnection server) throws InstanceNotFoundException, NullPointerException, IOException {
        this(server, flightRecorderName);
    }

    public FlightRecorderClient(MBeanServerConnection server, ObjectName name) throws InstanceNotFoundException, NullPointerException, IOException {
        FlightRecorderMBean f = null;
        this.server = server;
        this.remote = f = MBeanServerInvocationHandler.newProxyInstance(server, name, FlightRecorderMBean.class, true);
    }

    private void checkBound() {
    }

    @Override
    public ObjectName createRecording(String name) {
        this.checkBound();
        return this.remote.createRecording(name);
    }

    private FlightRecordingMBean getRecording(ObjectName name) throws NoSuchRecordingException {
        if (this.server != null) {
            return MBeanServerInvocationHandler.newProxyInstance(this.server, name, FlightRecordingMBean.class, true);
        }
        if (this.remote instanceof FlightRecorder) {
            FlightRecorder fr = (FlightRecorder)this.remote;
            try {
                return fr.getRecordingMBean(name);
            }
            catch (OpenDataException e) {
                throw (InternalError)new InternalError(e.getMessage()).initCause(e);
            }
        }
        throw new NoSuchRecordingException(name.toString());
    }

    public FlightRecordingClient createRecordingObject(String name) throws NoSuchRecordingException {
        ObjectName objectName = this.createRecording(name);
        return new FlightRecordingClient(this, this.getRecording(objectName), objectName);
    }

    @Override
    public ObjectName startRecording(String name, CompositeData options, List<CompositeData> eventSettings, List<CompositeData> eventDefaults) throws OpenDataException {
        return this.remote.startRecording(name, options, eventSettings, eventDefaults);
    }

    public FlightRecordingClient startRecordingObject(String name, CompositeData options, List<CompositeData> eventSettings, List<CompositeData> eventDefaults) throws OpenDataException {
        ObjectName objectName = this.startRecording(name, options, eventSettings, eventDefaults);
        try {
            return new FlightRecordingClient(this, this.getRecording(objectName), objectName);
        }
        catch (NoSuchRecordingException e) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(ObjectName recording, String path, boolean compress) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.remote.copyTo(recording, path, compress);
    }

    @Override
    public void disableDefaultRecording() {
        this.checkBound();
        this.remote.disableDefaultRecording();
    }

    @Override
    public void enableDefaultRecording() {
        this.checkBound();
        this.remote.enableDefaultRecording();
    }

    @Override
    public boolean isDefaultRecordingRunning() {
        this.checkBound();
        return this.remote.isDefaultRecordingRunning();
    }

    @Override
    public long getDataSize(ObjectName recording) throws NoSuchRecordingException {
        this.checkBound();
        return this.remote.getDataSize(recording);
    }

    @Override
    public void addEventDefaults(ObjectName recording, List<CompositeData> defaults) throws OpenDataException, NoSuchRecordingException {
        this.remote.addEventDefaults(recording, defaults);
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.remote.getEventDefaults();
    }

    @Override
    public List<CompositeData> getEventDefaults(ObjectName recording) throws OpenDataException, NoSuchRecordingException {
        return this.remote.getEventDefaults(recording);
    }

    @Override
    public void setEventDefaults(ObjectName recording, List<CompositeData> defaults) throws OpenDataException, NoSuchRecordingException {
        this.remote.setEventDefaults(recording, defaults);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        this.checkBound();
        return this.remote.getEventSettings();
    }

    @Override
    public List<CompositeData> getProducers() throws OpenDataException {
        this.checkBound();
        return this.remote.getProducers();
    }

    @Override
    public List<CompositeData> getRecordings() throws OpenDataException {
        this.checkBound();
        return this.remote.getRecordings();
    }

    public List<FlightRecordingClient> getRecordingObjects() throws OpenDataException, NoSuchRecordingException {
        List<CompositeData> cl = this.getRecordings();
        ArrayList<FlightRecordingClient> l = new ArrayList<FlightRecordingClient>(cl.size());
        for (CompositeData d : cl) {
            ObjectName name = (ObjectName)d.get("objectName");
            try {
                l.add(new FlightRecordingClient(this, this.getRecording(name), name));
            }
            catch (NoSuchRecordingException e) {}
        }
        return l;
    }

    @Override
    public void close(ObjectName recording) throws NoSuchRecordingException {
        this.checkBound();
        this.remote.close(recording);
    }

    @Override
    public void closeStream(long id) throws IOException, IllegalArgumentException {
        this.checkBound();
        this.remote.closeStream(id);
    }

    @Override
    public List<CompositeData> getEventSettings(ObjectName recording) throws OpenDataException, NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.getEventSettings(recording);
    }

    @Override
    public long getPeriod(ObjectName recording, int id) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.getPeriod(recording, id);
    }

    @Override
    public CompositeData getRecordingOptions(ObjectName recording) throws OpenDataException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.getRecordingOptions(recording);
    }

    @Override
    public long getThreshold(ObjectName recording, int id) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.getThreshold(recording, id);
    }

    @Override
    public boolean isEventEnabled(ObjectName recording, int id) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.isEventEnabled(recording, id);
    }

    @Override
    public boolean isStackTraceEnabled(ObjectName recording, int id) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.isStackTraceEnabled(recording, id);
    }

    @Override
    public long openStream(ObjectName recording, Date start, Date end) throws IOException, NoSuchRecordingException {
        this.checkBound();
        return this.remote.openStream(recording, start, end);
    }

    @Override
    public long openStream(ObjectName recording) throws NoSuchRecordingException, IOException {
        this.checkBound();
        return this.remote.openStream(recording);
    }

    @Override
    public byte[] readStream(long id) throws IOException, IllegalArgumentException {
        this.checkBound();
        return this.remote.readStream(id);
    }

    @Override
    public void setEventEnabled(ObjectName recording, int id, boolean on) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        this.remote.setEventEnabled(recording, id, on);
    }

    @Override
    public void setPeriod(ObjectName recording, int id, long threshold) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        this.remote.setPeriod(recording, id, threshold);
    }

    @Override
    public void setRecordingOptions(ObjectName recording, CompositeData options) throws OpenDataException, NoSuchRecordingException {
        this.checkBound();
        this.remote.setRecordingOptions(recording, options);
    }

    @Override
    public void setStackTraceEnabled(ObjectName recording, int id, boolean on) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        this.remote.setStackTraceEnabled(recording, id, on);
    }

    @Override
    public void setThreshold(ObjectName recording, int id, long threshold) throws NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        this.remote.setThreshold(recording, id, threshold);
    }

    @Override
    public void start(ObjectName recording) throws NoSuchRecordingException {
        this.checkBound();
        this.remote.start(recording);
    }

    @Override
    public void stop(ObjectName recording) throws NoSuchRecordingException, IOException {
        this.checkBound();
        this.remote.stop(recording);
    }

    @Override
    public void updateEventSettings(ObjectName recording, List<CompositeData> settings) throws OpenDataException, NoSuchEventException, NoSuchRecordingException {
        this.checkBound();
        this.remote.updateEventSettings(recording, settings);
    }

    @Override
    public long getThreshold(int id) throws NoSuchEventException {
        this.checkBound();
        return this.remote.getThreshold(id);
    }

    @Override
    public boolean isEventEnabled(int id) throws NoSuchEventException {
        this.checkBound();
        return this.remote.isEventEnabled(id);
    }

    @Override
    public boolean isStackTraceEnabled(int id) throws NoSuchEventException {
        this.checkBound();
        return this.remote.isStackTraceEnabled(id);
    }

    @Override
    public List<CompositeData> getEventDescriptors() throws OpenDataException {
        this.checkBound();
        return this.remote.getEventDescriptors();
    }

    @Override
    public ObjectName cloneRecording(ObjectName recording, String newName, boolean stop) throws NoSuchRecordingException, IOException {
        this.checkBound();
        return this.remote.cloneRecording(recording, newName, stop);
    }

    public FlightRecordingClient cloneRecordingObject(ObjectName recording, String newName, boolean stop) throws NoSuchRecordingException, IOException {
        ObjectName name = this.cloneRecording(recording, newName, stop);
        return new FlightRecordingClient(this, this.getRecording(name), name);
    }

    @Override
    public void copyTo(ObjectName recording, String path) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.checkBound();
        this.remote.copyTo(recording, path);
    }

    @Override
    public List<CompositeData> getAvailablePresets() throws OpenDataException {
        return this.remote.getAvailablePresets();
    }

    @Override
    public long getMaximumRepositoryChunkSize() {
        return this.remote.getMaximumRepositoryChunkSize();
    }

    @Override
    public long getGlobalBufferSize() {
        return this.remote.getGlobalBufferSize();
    }

    @Override
    public long getThreadBufferSize() {
        return this.remote.getThreadBufferSize();
    }

    @Override
    public long getNumGlobalBuffers() {
        return this.remote.getNumGlobalBuffers();
    }

    @Override
    public String getRepositoryPath() {
        return this.remote.getRepositoryPath();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Flight Recorder MBean Client = {\n");
        try {
            for (FlightRecordingClient r : this.getRecordingObjects()) {
                buf.append('\t').append(r).append('\n');
            }
        }
        catch (Exception e) {
            buf.append(e);
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public CompositeData getRecordingOptionsDefaults() throws OpenDataException {
        return this.remote.getRecordingOptionsDefaults();
    }

    @Override
    public CompositeData getStatistics() throws OpenDataException {
        return this.remote.getStatistics();
    }

    @Override
    public Date getDataEndTime(ObjectName recording) throws NoSuchRecordingException {
        return this.remote.getDataEndTime(recording);
    }

    @Override
    public Date getDataStartTime(ObjectName recording) throws NoSuchRecordingException {
        return this.remote.getDataStartTime(recording);
    }

    static {
        try {
            flightRecorderName = new ObjectName("com.oracle.jrockit:type=FlightRecorder");
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e);
        }
    }
}

