/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.openmbean.EventDefaultType;
import oracle.jrockit.jfr.openmbean.EventDescriptorType;
import oracle.jrockit.jfr.openmbean.EventSettingType;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSettingsBuilder {
    private final ArrayList<EventDefaultSet> eventDefaultSets = new ArrayList();
    private final ArrayList<EventSetting> settings = new ArrayList();
    private final EventDescriptorType eventDescriptorType;
    private final EventSettingType eventSettingType;
    private final EventDefaultType eventDefaultType;

    public EventSettingsBuilder() {
        try {
            this.eventDescriptorType = new EventDescriptorType();
            this.eventSettingType = new EventSettingType(null);
            this.eventDefaultType = new EventDefaultType();
        }
        catch (OpenDataException e) {
            throw new InternalError();
        }
    }

    public void addSettings(File settingsFile) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(new EventDefaultSet(settingsFile));
    }

    public void addSettings(String settingsFile) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(new EventDefaultSet(settingsFile));
    }

    public void addSettings(Reader r) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(new EventDefaultSet(r));
    }

    public void addSettings(EventDefaultSet set) {
        this.eventDefaultSets.add(set);
    }

    public void createSetting(String uriExpr, boolean enable, boolean stacktrace, long threshold, long period) throws URISyntaxException {
        this.eventDefaultSets.add(new EventDefaultSet(new EventDefault(new URI(uriExpr), new EventSetting(0, enable, stacktrace, threshold, period))));
    }

    public void createSetting(int id, boolean enable, boolean stacktrace, long threshold, long period) throws URISyntaxException {
        this.settings.add(new EventSetting(id, enable, stacktrace, threshold, period));
    }

    public List<CompositeData> createSettings(FlightRecorderMBean jfr) throws OpenDataException {
        ArrayList<CompositeData> l = new ArrayList<CompositeData>();
        if (!this.eventDefaultSets.isEmpty()) {
            for (CompositeData d : jfr.getProducers()) {
                CompositeData[] events = (CompositeData[])d.get("events");
                for (EventDescriptor e : this.eventDescriptorType.toJavaTypeData(Arrays.asList(events))) {
                    EventSetting s = null;
                    for (EventDefaultSet f : this.eventDefaultSets) {
                        EventSetting o = f.get(e.getURI());
                        if (o == null) continue;
                        s = s != null ? new EventSetting(s, o) : new EventSetting(e, o);
                    }
                    if (s == null) continue;
                    l.add(this.eventSettingType.toCompositeTypeData(s));
                }
            }
        }
        l.addAll(this.eventSettingType.toCompositeData(this.settings));
        return l;
    }

    public List<CompositeData> createDefaultSettings() throws OpenDataException {
        ArrayList<EventDefault> l = new ArrayList<EventDefault>();
        for (EventDefaultSet d : this.eventDefaultSets) {
            l.addAll(d.getAll());
        }
        return this.eventDefaultType.toCompositeData(l);
    }
}

