/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.DelgatingDynamicRequestableEvent;
import com.oracle.jrockit.jfr.DurationEvent;
import com.oracle.jrockit.jfr.DynamicEventToken;
import com.oracle.jrockit.jfr.DynamicValue;
import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.RequestDelegate;
import com.oracle.jrockit.jfr.TimedEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.DynamicValueDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Producer {
    private final JFR jfr;
    private final String name;
    private final String description;
    private final URI uri;
    private final List<EventToken> tokens = new ArrayList<EventToken>();
    private final List<EventHandler> events = new ArrayList<EventHandler>();
    private int id;
    private boolean unregistered;
    private boolean enabled;
    private final HashMap<String, StringConstantPool> constantPools = new HashMap();
    private static final Map<Class<? extends InstantEvent>, EventToken> globalTokens = new ConcurrentHashMap<Class<? extends InstantEvent>, EventToken>();
    private static final Object globalTokenLock = new Object();
    private static final HashSet<URI> knownURIs = new HashSet();

    static EventToken locateToken(Class<? extends InstantEvent> type) {
        EventToken t = globalTokens.get(type);
        if (t == null) {
            throw new IllegalArgumentException(type.getName() + " is not registered");
        }
        return t;
    }

    public Producer(String name, String description, URI uri) {
        if (!uri.toString().endsWith("/")) {
            try {
                uri = new URI(uri.toString() + "/");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.name = name;
        this.description = description;
        this.jfr = JFR.get();
        this.uri = uri;
    }

    public Producer(String name, String description, String uri) throws URISyntaxException {
        this(name, description, new URI(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register() {
        if (this.id != 0) {
            throw new IllegalStateException("Already registered.");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Unregistered producer");
        }
        Object object = globalTokenLock;
        synchronized (object) {
            if (knownURIs.contains(this.uri)) {
                throw new IllegalStateException("Producer with URI " + this.uri + " already exists");
            }
            knownURIs.add(this.uri);
        }
        this.id = this.jfr.nextID();
        this.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() throws IllegalStateException {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        this.disable();
        try {
            HashSet<EventToken> set = new HashSet<EventToken>(this.events.size());
            set.addAll(this.tokens);
            Object object = globalTokenLock;
            synchronized (object) {
                knownURIs.remove(this.uri);
                Iterator<EventToken> i = globalTokens.values().iterator();
                while (i.hasNext()) {
                    EventToken t = i.next();
                    if (!set.contains(t)) continue;
                    i.remove();
                }
            }
        }
        finally {
            this.unregistered = true;
        }
    }

    public synchronized void enable() {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        if (this.enabled) {
            return;
        }
        for (StringConstantPool pool : this.constantPools.values()) {
            pool.enable();
        }
        this.jfr.addProducer(this, this.id, this.events, this.constantPools);
        this.enabled = true;
    }

    public synchronized void disable() {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        if (!this.enabled) {
            return;
        }
        this.jfr.removeProducer(this.id);
        for (StringConstantPool pool : this.constantPools.values()) {
            pool.disable();
        }
        this.enabled = false;
    }

    private void add(EventToken t, EventHandler e) throws InvalidEventDefinitionException {
        String path = t.getPath();
        for (EventToken o : this.tokens) {
            if (!o.getPath().equals(path)) continue;
            throw new IllegalArgumentException("Event with path " + path + " already exists in this producer");
        }
        this.events.add(e);
        this.tokens.add(t);
        if (this.enabled) {
            this.jfr.addEventsToRegisteredProducer(this, this.id, Collections.singletonList(e), this.constantPools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventToken addEvent(Class<? extends InstantEvent> eventClass) throws InvalidEventDefinitionException, InvalidValueException {
        if (this.getToken(eventClass) != null) {
            throw new IllegalArgumentException("The event class has already been added.");
        }
        int id = this.jfr.nextID();
        JavaEventDescriptor d = new JavaEventDescriptor(eventClass, this.uri, id);
        EventHandler e = this.jfr.createHandler(d, eventClass, this.constantPools);
        EventToken t = new EventToken(e);
        this.add(t, e);
        if (id != 0) {
            Object object = globalTokenLock;
            synchronized (object) {
                if (globalTokens.containsKey(eventClass)) {
                    throw new IllegalStateException("Class " + eventClass + " already registered in another producer");
                }
                globalTokens.put(eventClass, t);
            }
        }
        return t;
    }

    private synchronized DynamicEventToken createDynamicEvent(Class<? extends InstantEvent> eventClass, String name, String description, String path, boolean addThread, boolean addStacktrace, RequestDelegate delegate, DynamicValue ... values) throws InvalidEventDefinitionException {
        ValueDescriptor[] descriptors = new DynamicValueDescriptor[values.length];
        int i = 0;
        for (DynamicValue dv : values) {
            ValueDescriptor d = dv.getDescriptor();
            descriptors[i] = new DynamicValueDescriptor(d, i);
            ++i;
        }
        int id = this.jfr.nextID();
        JavaEventDescriptor d = new JavaEventDescriptor(eventClass, this.uri, id, name, description, path, addThread, addStacktrace, descriptors);
        EventHandler e = this.jfr.createHandler(d, Object[].class, this.constantPools);
        DynamicEventToken t = new DynamicEventToken(e, delegate);
        this.add(t, e);
        return t;
    }

    public DynamicEventToken createDynamicInstantEvent(String name, String description, String path, boolean addThread, boolean addStacktrace, DynamicValue ... values) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(InstantEvent.class, name, description, path, addThread, addStacktrace, null, values);
    }

    public DynamicEventToken createDynamicDurationEvent(String name, String description, String path, boolean addThread, boolean addStacktrace, DynamicValue ... values) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(DurationEvent.class, name, description, path, addThread, addStacktrace, null, values);
    }

    public DynamicEventToken createDynamicTimedEvent(String name, String description, String path, boolean addThread, boolean addStacktrace, DynamicValue ... values) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(TimedEvent.class, name, description, path, addThread, addStacktrace, null, values);
    }

    public DynamicEventToken createDynamicRequestableEvent(String name, String description, String path, boolean addThread, boolean addStacktrace, RequestDelegate delegate, DynamicValue ... values) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(DelgatingDynamicRequestableEvent.class, name, description, path, addThread, addStacktrace, delegate, values);
    }

    private EventToken getToken(Class<? extends InstantEvent> eventClass) {
        for (EventToken t : this.tokens) {
            if (t.getEventInfo().getDescriptor().getEventClass() != eventClass) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConstantPool(Class<?> type, String name, int initSize, int maxSize, boolean emptyOnRotation) {
        if (type != String.class) {
            throw new IllegalArgumentException("Unsupported constant pool type " + type);
        }
        Producer producer = this;
        synchronized (producer) {
            if (this.constantPools.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate constant pool " + name);
            }
            StringConstantPool pool = new StringConstantPool(this.jfr, this.jfr.nextID(), maxSize, emptyOnRotation);
            this.constantPools.put(name, pool);
            if (this.enabled) {
                pool.enable();
            }
        }
    }

    public synchronized EventToken getEventToken(Class<? extends InstantEvent> eventClass) {
        EventToken t = this.getToken(eventClass);
        if (t == null) {
            throw new IllegalArgumentException(eventClass + " not registered");
        }
        return t;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getURI() {
        return this.uri;
    }

    public synchronized boolean isRegistered() {
        return this.id != 0 && !this.unregistered;
    }

    public synchronized boolean isUnregistered() {
        return this.unregistered;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Producer producer = this;
        synchronized (producer) {
            if (this.id != 0 && !this.unregistered) {
                this.unregister();
            }
        }
    }
}

