/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm.event;

import com.bea.jvm.CodeGenerationStrategy;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OptimizationLevel;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EventObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationEvent
extends EventObject {
    private static final long serialVersionUID = -1462345329837025993L;
    private CodeGenerationStrategy strategy;
    private OptimizationLevel optimizationLevel;
    private long compilationTime;

    public CompilationEvent(Method method, OptimizationLevel optimizationlevel, long compilationTime) {
        super(method);
        this.compilationTime = compilationTime;
        this.optimizationLevel = optimizationlevel;
    }

    public CompilationEvent(Method method, CodeGenerationStrategy strategy, long compilationTime) {
        super(method);
        this.strategy = strategy;
        this.compilationTime = compilationTime;
    }

    public CompilationEvent(Constructor<?> constructor, OptimizationLevel optimizationlevel, long compilationTime) {
        super(constructor);
        this.compilationTime = compilationTime;
        this.optimizationLevel = optimizationlevel;
    }

    public CompilationEvent(Constructor<?> constructor, CodeGenerationStrategy strategy, long compilationTime) {
        super(constructor);
        this.strategy = strategy;
        this.compilationTime = compilationTime;
    }

    public CompilationEvent(Object constructorOrMethod, CodeGenerationStrategy strategy, OptimizationLevel optimizationLevel, long compilationTime) {
        super(constructorOrMethod);
        this.strategy = strategy;
        this.optimizationLevel = optimizationLevel;
        this.compilationTime = compilationTime;
    }

    public CompilationEvent(AccessibleObject constructorOrMethod, CodeGenerationStrategy strategy, OptimizationLevel optimizationLevel, long compilationTime) {
        super(constructorOrMethod);
        this.strategy = strategy;
        this.optimizationLevel = optimizationLevel;
        this.compilationTime = compilationTime;
    }

    public OptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public Method getMethod() throws NotAvailableException {
        if (this.getSource() instanceof Method) {
            return (Method)this.getSource();
        }
        return null;
    }

    public Constructor<?> getConstructor() throws NotAvailableException {
        if (this.hasConstructor()) {
            return (Constructor)this.getSource();
        }
        return null;
    }

    public boolean hasConstructor() {
        return this.getSource() instanceof Constructor;
    }

    public long getCompilationTime() {
        return this.compilationTime;
    }

    public CodeGenerationStrategy getCodeGenerationStrategy() {
        return this.strategy;
    }
}

