/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm;

import bea.jmapi.JVMImpl;
import com.bea.jvm.JVM;
import com.bea.jvm.NotAvailableException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class JVMFactory {
    private static JVM jvm;

    public static synchronized JVM getJVM() throws NotAvailableException {
        if (jvm == null) {
            jvm = JVMFactory.createJVM();
        }
        return jvm;
    }

    private static JVM createJVM() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JVM>(){

                @Override
                public JVM run() throws Exception {
                    return new JVMImpl();
                }
            });
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NotAvailableException("JVM implementation " + e);
        }
    }
}

