/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm;

import com.bea.jvm.CPU;
import com.bea.jvm.ClassLibrary;
import com.bea.jvm.CompilationSystem;
import com.bea.jvm.Describable;
import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.LoggingSystem;
import com.bea.jvm.Machine;
import com.bea.jvm.MemorySystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OperatingSystem;
import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.ThreadSystem;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JVM
extends Describable {
    public ThreadSystem getThreadSystem() throws NotAvailableException;

    public MemorySystem getMemorySystem() throws NotAvailableException;

    public ClassLibrary getClassLibrary() throws NotAvailableException;

    public OperatingSystem getOperatingSystem() throws NotAvailableException;

    public CompilationSystem getCompilationSystem() throws NotAvailableException;

    public ProfilingSystem getProfilingSystem() throws NotAvailableException;

    public LoggingSystem getLoggingSystem() throws NotAvailableException;

    public Machine getMachine() throws NotAvailableException;

    public DiagnosticCommand getDiagnosticCommand();

    public String getVendor() throws NotAvailableException;

    public String getVersion() throws NotAvailableException;

    public String getName() throws NotAvailableException;

    public void suggestProcessAffinity(Collection<CPU> var1) throws NotAvailableException;

    public Collection<CPU> getProcessAffinity() throws NotAvailableException;

    public long getStartTime() throws NotAvailableException;

    public double getJVMLoad() throws NotAvailableException;

    @Override
    public String getDescription();

    public String getJVMInitArgs();

    public String getJavaCommandLine();
}

