/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm;

import bea.jmapi.DiagnosticCommandImpl;
import com.bea.jvm.Describable;
import com.bea.jvm.NotAvailableException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagnosticCommand
implements Describable {
    private final Map<String, Command> commands;

    public static DiagnosticCommand getDiagnosticCommand() {
        return new DiagnosticCommandImpl();
    }

    protected DiagnosticCommand() {
        String[] names = this.getAvailableCommandNames();
        HashMap<String, Command> map = new HashMap<String, Command>();
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            map.put(names[i], new Command(names[i]));
        }
        this.commands = Collections.unmodifiableMap(Collections.synchronizedMap(map));
    }

    public Collection<Command> getCommands() {
        return this.commands.values();
    }

    public Command getCommand(String name) throws NotAvailableException {
        Command c = this.commands.get(name);
        if (c == null) {
            try {
                this.getDescription(name);
                c = new Command(name, true);
            }
            catch (NotAvailableException e) {
                throw new NotAvailableException(name);
            }
        }
        return c;
    }

    public abstract String[] getAvailableCommandNames();

    private String command(String command, String args) {
        if (command.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid command name: " + command);
        }
        if (args == null || args.length() == 0) {
            return command;
        }
        return command + " " + args;
    }

    private String params(Collection<Parameter> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (Parameter p : params) {
            buf.append(p.getName()).append('=').append(p.param()).append(' ');
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    private String params(Map<String, ?> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<Parameter> res = new ArrayList<Parameter>();
        for (Map.Entry<String, ?> e : params.entrySet()) {
            res.add(new Parameter(e.getKey(), e.getValue()));
        }
        return this.params(res);
    }

    public abstract void execute(String var1, OutputStream var2) throws IllegalArgumentException, RuntimeException, IOException;

    public void execute(String command, String args, OutputStream resultstream) throws IllegalArgumentException, RuntimeException, IOException {
        this.execute(this.command(command, args), resultstream);
    }

    public void execute(String command, Collection<Parameter> args, OutputStream resultstream) throws IllegalArgumentException, RuntimeException, IOException {
        this.execute(this.command(command, this.params(args)), resultstream);
    }

    public void execute(String command, Map<String, ?> args, OutputStream resultstream) throws IllegalArgumentException, RuntimeException, IOException {
        this.execute(this.command(command, this.params(args)), resultstream);
    }

    public abstract void executeDefault(String var1) throws IllegalArgumentException, RuntimeException;

    public void executeDefault(String command, String args) throws IllegalArgumentException, RuntimeException {
        this.executeDefault(this.command(command, args));
    }

    public void executeDefault(String command, Collection<Parameter> args) throws IllegalArgumentException, RuntimeException {
        this.executeDefault(this.command(command, this.params(args)));
    }

    public void executeDefault(String command, Map<String, ?> args) throws IllegalArgumentException, RuntimeException {
        this.executeDefault(this.command(command, this.params(args)));
    }

    public String execute(String command) throws IllegalArgumentException, RuntimeException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            this.execute(command, bos);
            return bos.toString(this.getDefaultEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String execute(String command, String args) throws IllegalArgumentException, RuntimeException {
        return this.execute(this.command(command, args));
    }

    public String execute(String command, Collection<Parameter> args) throws IllegalArgumentException, RuntimeException {
        return this.execute(this.command(command, this.params(args)));
    }

    public String execute(String command, Map<String, ?> args) throws IllegalArgumentException, RuntimeException {
        return this.execute(this.command(command, this.params(args)));
    }

    protected String getDefaultEncoding() {
        return "UTF-8";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DiagnosticCommands {\n");
        for (Command c : this.commands.values()) {
            buf.append(c);
            buf.append('\n');
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public abstract Collection<Parameter> getParameters(String var1);

    public abstract String getDescription(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter
    implements Describable {
        private final String name;
        private final String description;
        private final int type;
        private final boolean required;
        private final Object defaultValue;
        private final Object value;

        Parameter(String name, String description, int type, boolean required, Object defaultValue, Object value) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        Parameter(String name, String description, int type, boolean required, Object defaultValue) {
            this(name, description, type, required, defaultValue, defaultValue);
        }

        private Parameter(String name, int type, Object value) {
            this(name, null, type, false, value, value);
        }

        public Parameter(String name, int value) {
            this(name, 73, new Integer(value));
        }

        public Parameter(String name, long value) {
            this(name, 74, new Long(value));
        }

        public Parameter(String name, double value) {
            this(name, 68, new Double(value));
        }

        public Parameter(String name, boolean value) {
            this(name, 90, new Boolean(value));
        }

        public Parameter(String name, Object value) {
            this(name, Parameter.typeFor(value), value);
        }

        public Parameter(String name, String value) {
            this(name, 76, value);
        }

        private static int typeFor(Object value) {
            if (value instanceof Integer) {
                return 73;
            }
            if (value instanceof Long) {
                return 74;
            }
            if (value instanceof Double) {
                return 68;
            }
            if (value instanceof Boolean) {
                return 90;
            }
            return 76;
        }

        String param() {
            String s = String.valueOf(this.value);
            if (s.indexOf(32) != -1) {
                s = "\"" + s + "\"";
            }
            return s;
        }

        @Override
        public String getDescription() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name);
            buf.append(" - ");
            buf.append('(').append(this.typeString());
            if (!this.required && this.defaultValue != null) {
                buf.append(", ").append(this.defaultValue);
            }
            buf.append(") ").append(this.description);
            return buf.toString();
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Class<?> getTypeClass() {
            switch (this.type) {
                case 73: {
                    return Integer.TYPE;
                }
                case 74: {
                    return Long.TYPE;
                }
                case 68: {
                    return Double.TYPE;
                }
                case 90: {
                    return Boolean.TYPE;
                }
                case 76: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("bad type " + (char)this.type);
        }

        private String typeString() {
            switch (this.type) {
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 68: {
                    return "double";
                }
                case 90: {
                    return "boolean";
                }
                case 76: {
                    return "string";
                }
            }
            throw new IllegalArgumentException("bad type " + (char)this.type);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name).append('=').append(this.param());
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Command
    implements Describable {
        private final String name;
        private String description;
        private Collection<Parameter> parameters;
        private final boolean hidden;

        Command(String name) {
            this(name, false);
        }

        Command(String name, boolean hidden) {
            this.name = name;
            this.hidden = hidden;
        }

        boolean isHidden() {
            return this.hidden;
        }

        public String execute(String params) throws IllegalArgumentException, RuntimeException {
            return DiagnosticCommand.this.execute(this.name, params);
        }

        public String execute(Collection<Parameter> params) throws IllegalArgumentException, RuntimeException {
            return this.execute(DiagnosticCommand.this.params(params));
        }

        public String execute(Map<String, ?> params) throws IllegalArgumentException, RuntimeException {
            return this.execute(DiagnosticCommand.this.params(params));
        }

        public String execute() throws IllegalArgumentException, RuntimeException {
            return DiagnosticCommand.this.execute(this.name);
        }

        public String help() {
            return DiagnosticCommand.this.execute("help", this.name);
        }

        public void executeDefault(String params) throws IllegalArgumentException, RuntimeException {
            DiagnosticCommand.this.executeDefault(this.name, params);
        }

        public void executeDefault(Collection<Parameter> params) throws IllegalArgumentException, RuntimeException {
            this.executeDefault(DiagnosticCommand.this.params(params));
        }

        public void executeDefault(Map<String, ?> params) throws IllegalArgumentException, RuntimeException {
            this.executeDefault(DiagnosticCommand.this.params(params));
        }

        public void executeDefault() throws IllegalArgumentException, RuntimeException {
            DiagnosticCommand.this.executeDefault(this.name);
        }

        public void helpDefault() {
            DiagnosticCommand.this.executeDefault("help", this.name);
        }

        public void execute(String params, OutputStream os) throws IOException, IllegalArgumentException, RuntimeException {
            DiagnosticCommand.this.execute(this.name, params, os);
        }

        public void execute(Collection<Parameter> params, OutputStream os) throws IOException, IllegalArgumentException, RuntimeException {
            this.execute(DiagnosticCommand.this.params(params), os);
        }

        public void execute(Map<String, ?> params, OutputStream os) throws IOException, IllegalArgumentException, RuntimeException {
            this.execute(DiagnosticCommand.this.params(params), os);
        }

        public void execute(OutputStream os) throws IOException, IllegalArgumentException, RuntimeException {
            DiagnosticCommand.this.execute(this.name, os);
        }

        public void help(OutputStream os) throws IOException {
            DiagnosticCommand.this.execute("help", this.name, os);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            if (this.description == null) {
                this.description = DiagnosticCommand.this.getDescription(this.name);
            }
            return this.description;
        }

        public Collection<Parameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = DiagnosticCommand.this.getParameters(this.name);
            }
            return this.parameters;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name).append(" : ");
            if (this.hidden) {
                buf.append("(internal) ");
            }
            buf.append(this.getDescription());
            for (Parameter p : this.getParameters()) {
                buf.append("\n\t").append(p);
            }
            return buf.toString();
        }
    }
}

