/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.NoSuchThreadException;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ThreadSnapshot;
import com.bea.jvm.ThreadSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSystemImpl
extends JVMComponentImpl
implements ThreadSystem {
    private final DiagnosticCommand.Command printThreads;

    private static native void initIDs();

    public ThreadSystemImpl(JVMImpl jvm) {
        super(jvm);
        DiagnosticCommand.Command c;
        try {
            c = DiagnosticCommand.getDiagnosticCommand().getCommand("print_threads");
        }
        catch (NotAvailableException e) {
            c = null;
        }
        this.printThreads = c;
    }

    @Override
    public Collection<ThreadSnapshot> getThreadSnapshots() throws NotAvailableException {
        return Arrays.asList(this.getThreadSnapshots(this.getAllThreads0()));
    }

    private native ThreadSnapshot[] getThreadSnapshots(Thread[] var1);

    private ThreadSnapshot[] getThreadSnapshots(Collection<Thread> threads) {
        return this.getThreadSnapshots(threads.toArray(new Thread[threads.size()]));
    }

    @Override
    public ThreadSnapshot getThreadSnapshot(Thread t) {
        return this.getThreadSnapshots(new Thread[]{t})[0];
    }

    @Override
    public Collection<ThreadSnapshot> getThreadSnapshots(String name) {
        return Arrays.asList(this.getThreadSnapshots(this.getThreads(name)));
    }

    @Override
    public ThreadSnapshot getThreadSnapshot(long id) throws NoSuchThreadException {
        return this.getThreadSnapshots(new Thread[]{this.getThread(id)})[0];
    }

    @Override
    public native int getTotalThreadCount();

    @Override
    public native int getDaemonThreadCount();

    private native Thread[] getAllThreads0();

    @Override
    public Collection<Thread> getAllThreads() {
        return Arrays.asList(this.getAllThreads0());
    }

    private Collection<Thread> getThreads(ThreadFilter filter) {
        ArrayList<Thread> res = new ArrayList<Thread>();
        Thread[] threads = this.getAllThreads0();
        int n = threads.length;
        for (int i = 0; i < n; ++i) {
            if (!filter.accept(threads[i])) continue;
            res.add(threads[i]);
        }
        return res;
    }

    @Override
    public Collection<Thread> getThreads(final String name) {
        return this.getThreads(new ThreadFilter(){

            public boolean accept(Thread t) {
                return t.getName().equals(name);
            }
        });
    }

    @Override
    public native Thread getThread(long var1);

    @Override
    public boolean isUsingThinThreads() {
        return false;
    }

    @Override
    public String getThreadStackDump() {
        if (this.printThreads == null) {
            throw new NotAvailableException();
        }
        return this.printThreads.execute();
    }

    public String toString() {
        return "Thread System";
    }

    static {
        ThreadSystemImpl.initIDs();
    }

    private static interface ThreadFilter {
        public boolean accept(Thread var1);
    }
}

