/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import com.bea.jvm.CallTraceElement;
import com.bea.jvm.ThreadSnapshot;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import sun.misc.VM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSnapshotImpl
implements ThreadSnapshot {
    private String name;
    private int state;
    private int stateBitmap;
    private long id;
    private boolean daemon;
    private int priority;
    private CallTraceElement[] stackTrace;
    private ThreadSnapshot.Monitor blockedOnMonitor;
    private ThreadSnapshot.Monitor waitingOnMonitor;
    private static final Method toStateMethod;

    ThreadSnapshotImpl(String name, int state, int stateBitmap, long id, boolean daemon, int priority, CallTraceElement[] stackTrace, ThreadSnapshot.Monitor blockedOnMonitor, ThreadSnapshot.Monitor waitingOnMonitor) {
        this.name = name;
        this.state = state;
        this.stateBitmap = stateBitmap;
        this.id = id;
        this.daemon = daemon;
        this.priority = priority;
        this.stackTrace = stackTrace;
        this.blockedOnMonitor = blockedOnMonitor;
        this.waitingOnMonitor = waitingOnMonitor;
    }

    @Override
    public ThreadSnapshot.Monitor getBlockedOnMonitor() {
        return this.blockedOnMonitor;
    }

    @Override
    public boolean isDaemon() {
        return this.daemon;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<CallTraceElement> getStackTrace() {
        return Arrays.asList(this.stackTrace);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getStateBitmap() {
        return this.stateBitmap;
    }

    @Override
    public ThreadSnapshot.Monitor getWaitingOnMonitor() {
        return this.waitingOnMonitor;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public Object getThreadState() {
        if (toStateMethod != null) {
            try {
                return toStateMethod.invoke(null, new Integer(this.stateBitmap));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.describeState();
    }

    public String describeState() {
        StringBuilder buffer = new StringBuilder();
        int s = this.stateBitmap;
        if (s == 0) {
            return "not started";
        }
        if ((s & 2) != 0) {
            return "terminated";
        }
        buffer.append("alive");
        if ((s & 0x400000) != 0) {
            buffer.append(", in native");
        }
        if ((s & 0x20000000) != 0) {
            buffer.append(", in suspend critical mode");
        }
        if ((s & 0x100000) != 0) {
            buffer.append(", suspended");
        }
        if ((s & 0x200000) != 0) {
            buffer.append(", interrupted");
        }
        if ((s & 0x400) != 0) {
            buffer.append(", blocked");
            if ((s & 0x10000000) != 0) {
                buffer.append(" (on thin lock)");
            }
        } else if ((s & 0x80) != 0) {
            if ((s & 0x100) != 0) {
                buffer.append(", waiting");
            } else if ((s & 0x40) != 0) {
                buffer.append(", sleeping");
            } else {
                buffer.append(", parked");
            }
        }
        return buffer.toString();
    }

    public StringBuilder toString(StringBuilder buf) {
        buf.append("Thread-");
        buf.append(this.getID());
        buf.append(" \"");
        buf.append(this.getName());
        buf.append('\"');
        buf.append(" <");
        buf.append(this.describeState());
        buf.append(", priority=");
        buf.append(this.getPriority());
        if (this.isDaemon()) {
            buf.append(", DAEMON");
        }
        buf.append("> {\n");
        if (this.blockedOnMonitor != null) {
            buf.append("    -- Blocked trying to get lock: ");
            buf.append(this.blockedOnMonitor);
            buf.append("\n");
        }
        if (this.waitingOnMonitor != null) {
            buf.append("    -- Waiting for notification on: ");
            buf.append(this.waitingOnMonitor);
            buf.append("\n");
        }
        for (CallTraceElement entry : this.getStackTrace()) {
            buf.append("    ");
            buf.append(entry);
            buf.append('\n');
            ThreadSnapshot.Monitor[] monitors = entry.getMonitors();
            if (monitors == null || monitors.length <= 0) continue;
            for (int j = 0; j < monitors.length; ++j) {
                if (monitors[j].equals(this.waitingOnMonitor)) {
                    buf.append("    ^-- Lock released while waiting: ");
                    buf.append(monitors[j]);
                    buf.append("\n");
                    continue;
                }
                buf.append("    ^-- Holding lock: ");
                buf.append(monitors[j]);
                buf.append("\n");
            }
        }
        buf.append("}\n\n");
        return buf;
    }

    public String toString() {
        return this.toString(new StringBuilder(40 + this.getStackTrace().size() * 40)).toString();
    }

    static {
        Method m;
        try {
            m = VM.class.getDeclaredMethod("toThreadState", Integer.class);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        toStateMethod = m;
    }
}

