/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.ExceptionProfileImpl;
import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.MethodProfileImpl;
import com.bea.jvm.ConstructorProfileEntry;
import com.bea.jvm.ExceptionProfileEntry;
import com.bea.jvm.MethodProfileEntry;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.RunnableMemberProfileEntry;
import com.bea.jvm.UnapplicableMethodException;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingSystemImpl
extends JVMComponentImpl
implements ProfilingSystem {
    private WeakHashMap<AccessibleObject, SoftReference<RunnableMemberProfileEntry>> memberEntries = new WeakHashMap();
    private WeakHashMap<Class<? extends Throwable>, SoftReference<ExceptionProfileEntry>> exceptionEntries = new WeakHashMap();

    public ProfilingSystemImpl(JVMImpl jvm) {
        super(jvm);
    }

    private synchronized RunnableMemberProfileEntry lookup(AccessibleObject obj) {
        SoftReference<RunnableMemberProfileEntry> ref = this.memberEntries.get(obj);
        return ref != null ? ref.get() : null;
    }

    private synchronized RunnableMemberProfileEntry getMethodProfileEntry(Method method) throws NotAvailableException, UnapplicableMethodException {
        RunnableMemberProfileEntry res = this.lookup(method);
        if (res == null) {
            res = this.newMethodProfileEntry(method);
            this.memberEntries.put(method, new SoftReference<RunnableMemberProfileEntry>(res));
        }
        return res;
    }

    private synchronized RunnableMemberProfileEntry getMethodProfileEntry(Constructor<?> constructor) throws NotAvailableException, UnapplicableMethodException {
        RunnableMemberProfileEntry res = this.lookup(constructor);
        if (res == null) {
            res = this.newConstructorProfileEntry(constructor);
            this.memberEntries.put(constructor, new SoftReference<RunnableMemberProfileEntry>(res));
        }
        return res;
    }

    private synchronized ExceptionProfileEntry lookup(Class<? extends Throwable> throwableClass) {
        SoftReference<ExceptionProfileEntry> ref = this.exceptionEntries.get(throwableClass);
        return ref != null ? ref.get() : null;
    }

    private synchronized ExceptionProfileEntry getExceptionProfileEntry(Class<? extends Throwable> throwableClass) {
        ExceptionProfileEntry res = this.lookup(throwableClass);
        if (res == null) {
            res = this.newExceptionProfileEntry(throwableClass).getResetableInstance();
            this.exceptionEntries.put(throwableClass, new SoftReference<ExceptionProfileEntry>(res));
        }
        return res;
    }

    @Override
    public void setInvocationCountEnabled(Method method, boolean enable) throws NotAvailableException, UnapplicableMethodException {
        this.getMethodProfileEntry(method).setInvocationCountEnabled(enable);
    }

    @Override
    public void setInvocationCountEnabled(Constructor<?> constructor, boolean enable) throws NotAvailableException, UnapplicableMethodException {
        this.getMethodProfileEntry(constructor).setInvocationCountEnabled(enable);
    }

    @Override
    public boolean isInvocationCountEnabled(Method method) {
        RunnableMemberProfileEntry entry = this.lookup(method);
        return entry != null ? entry.isInvocationCountEnabled() : false;
    }

    @Override
    public boolean isInvocationCountEnabled(Constructor<?> constructor) throws NotAvailableException {
        RunnableMemberProfileEntry entry = this.lookup(constructor);
        return entry != null ? entry.isInvocationCountEnabled() : false;
    }

    @Override
    public long getInvocationCount(Method method) {
        RunnableMemberProfileEntry entry = this.lookup(method);
        return entry != null ? entry.getInvocations() : 0L;
    }

    @Override
    public long getInvocationCount(Constructor<?> constructor) throws NotAvailableException {
        RunnableMemberProfileEntry entry = this.lookup(constructor);
        return entry != null ? entry.getInvocations() : 0L;
    }

    @Override
    public void setTimingEnabled(Method method, boolean enable) throws UnapplicableMethodException {
        this.getMethodProfileEntry(method).setTimingEnabled(enable);
    }

    @Override
    public void setTimingEnabled(Constructor<?> constructor, boolean enable) throws NotAvailableException, UnapplicableMethodException {
        this.getMethodProfileEntry(constructor).setTimingEnabled(enable);
    }

    @Override
    public boolean isTimingEnabled(Method method) {
        RunnableMemberProfileEntry entry = this.lookup(method);
        return entry != null ? entry.isTimingEnabled() : false;
    }

    @Override
    public boolean isTimingEnabled(Constructor<?> constructor) throws NotAvailableException {
        RunnableMemberProfileEntry entry = this.lookup(constructor);
        return entry != null ? entry.isTimingEnabled() : false;
    }

    @Override
    public long getTiming(Method method) throws NotAvailableException {
        RunnableMemberProfileEntry entry = this.lookup(method);
        return entry != null ? entry.getTiming() : 0L;
    }

    @Override
    public long getTiming(Constructor<?> constructor) throws NotAvailableException {
        RunnableMemberProfileEntry entry = this.lookup(constructor);
        return entry != null ? entry.getTiming() : 0L;
    }

    @Override
    public void setExceptionCountEnabled(Class<? extends Throwable> throwableClass, boolean enable, boolean includeAllSubclasses) throws ClassCastException {
        ExceptionProfileEntry entry = this.getExceptionProfileEntry(throwableClass);
        entry.setSingleEnabled(enable);
        entry.setCompositeEnabled(enable && includeAllSubclasses);
    }

    @Override
    public long getExceptionCount(Class<? extends Throwable> throwableClass) throws ClassCastException {
        ExceptionProfileEntry entry = this.lookup(throwableClass);
        return entry != null ? (entry.isCompositeEnabled() ? entry.getCompositeCount() : entry.getSingleCount()) : 0L;
    }

    @Override
    public boolean isExceptionCountEnabled(Class<? extends Throwable> throwableClass) throws ClassCastException {
        ExceptionProfileEntry entry = this.lookup(throwableClass);
        return entry != null ? entry.isSingleEnabled() : false;
    }

    public String toString() {
        return "ProfilingSystem (" + this.memberEntries.size() + " methods, " + this.exceptionEntries.size() + " exception types profiled)";
    }

    @Override
    public ConstructorProfileEntry newConstructorProfileEntry(Constructor<?> constructor) throws NotAvailableException, UnapplicableMethodException {
        return new MethodProfileImpl(this.jvm, constructor);
    }

    @Override
    public ExceptionProfileEntry newExceptionProfileEntry(Class<? extends Throwable> throwAbleClass) throws NotAvailableException, IllegalArgumentException {
        return new ExceptionProfileImpl(this.jvm, throwAbleClass);
    }

    @Override
    public MethodProfileEntry newMethodProfileEntry(Method method) throws NotAvailableException, UnapplicableMethodException {
        return new MethodProfileImpl(this.jvm, method);
    }
}

