/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.MemoryImpl;
import com.bea.jvm.Memory;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OperatingSystem;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class OperatingSystemImpl
extends JVMComponentImpl
implements OperatingSystem {
    private String os;
    private final Memory virtualMemory;

    public OperatingSystemImpl(JVMImpl jvm) {
        super(jvm);
        String s;
        this.os = s = AccessController.doPrivileged(new GetPropertyAction("os.name", "Unknown"));
        this.virtualMemory = new MemoryImpl(jvm, "Virtual Memory"){

            public long getTotalMemory() {
                return OperatingSystemImpl.this.getTotalVirtualMemory();
            }

            public long getUsedMemory() {
                return OperatingSystemImpl.this.getUsedVirtualMemory();
            }
        };
    }

    private native long getTotalVirtualMemory();

    private native long getUsedVirtualMemory();

    private native int getProcessID0();

    public String getName() throws NotAvailableException {
        return this.os;
    }

    public Memory getVirtualMemory() throws NotAvailableException {
        return this.virtualMemory;
    }

    public String toString() {
        return this.getName() + "[" + this.virtualMemory + "]";
    }

    public int getProcessID() {
        return this.getProcessID0();
    }
}

