/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import com.bea.jvm.NIC;
import java.lang.reflect.Field;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class NICImpl
extends JVMComponentImpl
implements NIC {
    private final NetworkInterface nif;
    private String mac;
    private long mtu;
    private static final Field indexField;

    public NICImpl(JVMImpl jvm, NetworkInterface nif) {
        super(jvm);
        this.nif = nif;
        int i = -1;
        try {
            if (indexField != null) {
                i = indexField.getInt(nif);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.init(i);
    }

    private native void init(int var1);

    private static native void initIDs();

    public String getMAC() {
        return this.mac;
    }

    public long getMTU() {
        return this.mtu;
    }

    public String toString() {
        return this.nif.toString() + "[" + this.mac + "], " + this.mtu;
    }

    static {
        Field f;
        NICImpl.initIDs();
        try {
            f = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field f = NetworkInterface.class.getDeclaredField("index");
                        f.setAccessible(true);
                        return f;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        catch (Throwable t) {
            f = null;
        }
        indexField = f;
    }
}

