/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import com.bea.jvm.ThreadSnapshot;

class MonitorImpl
implements ThreadSnapshot.Monitor {
    final String className;
    private final long owner;
    private final int id;
    private final int type;

    public MonitorImpl(Object obj, long owner, int type) {
        this.className = obj.getClass().getName();
        this.id = System.identityHashCode(obj);
        this.owner = owner;
        this.type = type;
    }

    public String getClassName() {
        return this.className;
    }

    public long getID() {
        return this.id;
    }

    public int getLockType() {
        return this.type;
    }

    public String getLockTypeString() {
        switch (this.type) {
            case 0: {
                return "not locked";
            }
            case 1: {
                return "thin lock";
            }
            case 2: {
                return "fat lock";
            }
            case 3: {
                return "recursive lock";
            }
        }
        return "unknown";
    }

    public long getOwnerThreadID() {
        return this.owner;
    }

    public String getDescription() {
        return this.toString();
    }

    public String toString() {
        if (this.getLockType() == -1) {
            return this.className + "@" + Long.toHexString(this.id);
        }
        return this.className + "@" + Long.toHexString(this.id) + "[" + this.getLockTypeString() + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof ThreadSnapshot.Monitor) {
            ThreadSnapshot.Monitor m = (ThreadSnapshot.Monitor)o;
            return this.className.equals(m.getClassName()) && (long)this.id == m.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode() + this.id;
    }
}

