/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.BCMethodProf;
import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import com.bea.jvm.ConstructorProfileEntry;
import com.bea.jvm.MethodProfileEntry;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.RunnableMemberProfileEntry;
import com.bea.jvm.UnapplicableMethodException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.jrockit.os.Timing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodProfileImpl
extends JVMComponentImpl
implements MethodProfileEntry,
ConstructorProfileEntry {
    private final AccessibleObject member;
    private final BCMethodProf bcProf;
    private boolean timing;
    private boolean invocations;

    private MethodProfileImpl(JVMImpl jvm, AccessibleObject obj, int modifiers) throws NotAvailableException, UnapplicableMethodException {
        super(jvm);
        this.member = obj;
        if (Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers)) {
            throw new UnapplicableMethodException(obj.toString());
        }
        this.bcProf = this.isMethod() ? BCMethodProf.forMethod(jvm, this.getMethod()) : BCMethodProf.forConstructor(jvm, this.getConstructor());
    }

    public MethodProfileImpl(JVMImpl jvm, Constructor<?> constructor) throws NotAvailableException, UnapplicableMethodException {
        this(jvm, constructor, constructor.getModifiers());
    }

    public MethodProfileImpl(JVMImpl jvm, Method method) throws NotAvailableException, UnapplicableMethodException {
        this(jvm, method, method.getModifiers());
    }

    private boolean isMethod() {
        return this.member instanceof Method;
    }

    private boolean isConstructor() {
        return this.member instanceof Constructor;
    }

    @Override
    public Method getMethod() {
        return this.isMethod() ? (Method)this.member : null;
    }

    @Override
    public AccessibleObject getProfiled() {
        return this.member;
    }

    @Override
    public boolean isInvocationCountEnabled() {
        return this.invocations;
    }

    @Override
    public boolean isTimingEnabled() {
        return this.timing;
    }

    @Override
    public void setInvocationCountEnabled(boolean on) {
        this.setEnabled(on, this.isTimingEnabled());
    }

    @Override
    public void setTimingEnabled(boolean on) {
        this.setEnabled(this.isInvocationCountEnabled(), on);
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.isConstructor() ? (Constructor)this.member : null;
    }

    @Override
    public long getInvocations() {
        if (!this.invocations) {
            return 0L;
        }
        return this.bcProf.getInvocationCount();
    }

    @Override
    public long getTiming() {
        if (!this.timing) {
            return 0L;
        }
        return Timing.counterToMilli(this.bcProf.getTiming());
    }

    @Override
    public void setEnabled(boolean invocations, boolean timing) {
        this.setEnabled0(invocations, timing);
        this.invocations = invocations;
        this.timing = timing;
    }

    private synchronized void setEnabled0(boolean invocations, boolean timing) {
        if (invocations == this.invocations && timing == this.timing) {
            return;
        }
        if (invocations != this.invocations && invocations) {
            this.bcProf.enableInvocationCount();
        }
        if (invocations != this.invocations && !invocations) {
            this.bcProf.disableInvocationCount();
        }
        if (timing != this.timing && timing) {
            this.bcProf.enableTiming();
        }
        if (timing != this.timing && !timing) {
            this.bcProf.disableTiming();
        }
        this.bcProf.update();
    }

    @Override
    public RunnableMemberProfileEntry getResetableInstance() {
        return new ResetableEntry(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setEnabled(false, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResetableEntry
    implements MethodProfileEntry,
    ConstructorProfileEntry {
        private final MethodProfileImpl impl;
        private long invocationReset;
        private long timingReset;

        public ResetableEntry(MethodProfileImpl impl) {
            this.impl = impl;
        }

        public boolean equals(Object obj) {
            return this.impl.equals(obj);
        }

        @Override
        public Constructor<?> getConstructor() {
            return this.impl.getConstructor();
        }

        public String getDescription() {
            return this.impl.getDescription();
        }

        @Override
        public long getInvocations() {
            return this.impl.getInvocations() - this.invocationReset;
        }

        @Override
        public Method getMethod() {
            return this.impl.getMethod();
        }

        @Override
        public AccessibleObject getProfiled() {
            return this.impl.getProfiled();
        }

        @Override
        public long getTiming() {
            return this.impl.getTiming() - this.timingReset;
        }

        public int hashCode() {
            return this.impl.hashCode();
        }

        @Override
        public boolean isInvocationCountEnabled() {
            return this.impl.isInvocationCountEnabled();
        }

        @Override
        public boolean isTimingEnabled() {
            return this.impl.isTimingEnabled();
        }

        @Override
        public void setEnabled(boolean invocations, boolean timing) {
            this.setInvocationCountEnabled(invocations);
            this.setTimingEnabled(timing);
        }

        @Override
        public void setInvocationCountEnabled(boolean on) {
            this.impl.setInvocationCountEnabled(on);
            this.invocationReset = on ? this.getInvocations() : 0L;
        }

        @Override
        public void setTimingEnabled(boolean on) {
            this.impl.setTimingEnabled(on);
            this.timingReset = on ? this.getTiming() : 0L;
        }

        public String toString() {
            return this.impl.toString();
        }

        @Override
        public RunnableMemberProfileEntry getResetableInstance() {
            return this;
        }
    }
}

