/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import oracle.jrockit.os.Timing;

public final class MethodProfileData {
    public static long[] data = new long[30];
    private static int firstFree;
    private static int numEntries;

    private MethodProfileData() {
    }

    private static void init(int start, int next) {
        for (int i = start; i < data.length; ++i) {
            MethodProfileData.data[i] = i + 1;
        }
        MethodProfileData.data[i - 1] = next;
    }

    private static void resize() {
        int len = data.length;
        long[] newData = new long[len + 50];
        System.arraycopy(data, 0, newData, 0, len);
        data = newData;
        MethodProfileData.init(len, firstFree);
        firstFree = len;
    }

    static synchronized int newEntry() {
        int size = data.length;
        if (size == numEntries) {
            MethodProfileData.resize();
        }
        int res = firstFree;
        firstFree = (int)data[firstFree];
        ++numEntries;
        MethodProfileData.data[res] = 0L;
        return res;
    }

    static synchronized void release(int index) {
        MethodProfileData.data[index] = firstFree;
        firstFree = index;
        --numEntries;
    }

    public static void invoke(int index) {
        long[] l = data;
        int n = index;
        l[n] = l[n] + 1L;
    }

    public static long time() {
        return Timing.counterTime();
    }

    public static void timing(int index, long time) {
        long[] l = data;
        int n = index;
        l[n] = l[n] + (MethodProfileData.time() - time);
    }

    static long get(int index) {
        return data[index];
    }

    static {
        MethodProfileData.init(0, -1);
    }
}

